/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.registry;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.rftoolscontrol.api.parameters.Inventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class InventoryUtil {
    public static void writeBuf(Inventory inv, ByteBuf buf) {
        NetworkTools.writeString((ByteBuf)buf, (String)inv.getNodeName());
        buf.writeByte(inv.getSide().ordinal());
        buf.writeByte(inv.getIntSide() == null ? -1 : inv.getIntSide().ordinal());
    }

    public static Inventory readBuf(ByteBuf buf) {
        String nodeName = NetworkTools.readString((ByteBuf)buf);
        byte sideIdx = buf.readByte();
        EnumFacing side = EnumFacing.values()[sideIdx];
        sideIdx = buf.readByte();
        EnumFacing intSide = sideIdx == -1 ? null : EnumFacing.values()[sideIdx];
        return new Inventory(nodeName, side, intSide);
    }

    public static Inventory readFromNBT(NBTTagCompound tag) {
        String nodeName = null;
        if (tag.func_74764_b("node")) {
            nodeName = tag.func_74779_i("node");
        }
        byte sideIdx = tag.func_74771_c("side");
        EnumFacing side = EnumFacing.values()[sideIdx];
        sideIdx = tag.func_74771_c("intside");
        EnumFacing intSide = sideIdx == -1 ? null : EnumFacing.values()[sideIdx];
        return new Inventory(nodeName, side, intSide);
    }

    public static NBTTagCompound writeToNBT(Inventory inv) {
        NBTTagCompound tag = new NBTTagCompound();
        if (inv.hasNodeName()) {
            tag.func_74778_a("node", inv.getNodeName());
        }
        tag.func_74774_a("side", (byte)inv.getSide().ordinal());
        tag.func_74774_a("intside", (byte)(inv.getIntSide() == null ? -1 : inv.getIntSide().ordinal()));
        return tag;
    }
}

