/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.grid;

public class GridPos {
    private final int x;
    private final int y;

    public GridPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public GridPos up() {
        return new GridPos(this.x, this.y - 1);
    }

    public GridPos down() {
        return new GridPos(this.x, this.y + 1);
    }

    public GridPos left() {
        return new GridPos(this.x - 1, this.y);
    }

    public GridPos right() {
        return new GridPos(this.x + 1, this.y);
    }

    public String toString() {
        return "GridPos{" + this.x + "," + this.y + '}';
    }

    public static GridPos pos(int x, int y) {
        return new GridPos(x, y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridPos gridPos = (GridPos)o;
        if (this.x != gridPos.x) {
            return false;
        }
        return this.y == gridPos.y;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        return result;
    }
}

