/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.blocks;

import com.kashdeya.tinyprogressions.handlers.ConfigHandler;
import com.kashdeya.tinyprogressions.inits.TechBlocks;
import com.kashdeya.tinyprogressions.main.tinyprogressions;
import com.kashdeya.tinyprogressions.tiles.TileEntityGrowth;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrowth
extends Block
implements ITileEntityProvider {
    private int range = 4;
    private int rangeY = 2;

    public BlockGrowth() {
        super(Material.field_151578_c);
        this.func_149675_a(true);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149752_b(2000.0f);
        this.func_149715_a(1.0f);
        this.func_149713_g(1);
        this.func_149647_a(tinyprogressions.tabTP);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c("growth_block");
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityGrowth();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random par5Random) {
        this.growCropsNearby(world, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)TechBlocks.growth_block);
    }

    public void growCropsNearby(World world, BlockPos pos, IBlockState state) {
        int xO = pos.func_177958_n();
        int yO = pos.func_177956_o();
        int zO = pos.func_177952_p();
        for (int xD = -4; xD <= 4; ++xD) {
            for (int yD = -4; yD <= 4; ++yD) {
                for (int zD = -4; zD <= 4; ++zD) {
                    int x = xO + xD;
                    int y = yO + yD;
                    int z = zO + zD;
                    double distance = Math.sqrt(Math.pow(x - xO, 2.0) + Math.pow(y - yO, 2.0) + Math.pow(z - zO, 2.0));
                    distance = Math.max(1.0, distance);
                    double distanceCoefficient = 1.0 - 1.0 / distance;
                    IBlockState cropState = world.func_180495_p(new BlockPos(x, y, z));
                    Block cropBlock = cropState.func_177230_c();
                    if (!(cropBlock instanceof IPlantable) && !(cropBlock instanceof IGrowable) || cropBlock instanceof BlockGrowth) continue;
                    world.func_180497_b(new BlockPos(x, y, z), cropBlock, (int)(distanceCoefficient * (double)ConfigHandler.BlockGrowthTicks * 40.0), 1);
                    cropBlock.func_180650_b(world, new BlockPos(x, y, z), cropState, world.field_73012_v);
                }
            }
        }
        world.func_180497_b(pos, state.func_177230_c(), ConfigHandler.BlockGrowthTicks * 40, 1);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState worldIn, World pos, BlockPos state, Random rand) {
        super.func_180655_c(worldIn, pos, state, rand);
        for (int i = -4; i <= 4; ++i) {
            for (int j = -4; j <= 4; ++j) {
                if (i > -4 && i < 4 && j == -2) {
                    j = 4;
                }
                if (rand.nextInt(ConfigHandler.GrowthParticalTicks) != 0) continue;
                for (int k = 0; k <= 1; ++k) {
                    for (int xAxis = -this.range; xAxis <= this.range; ++xAxis) {
                        for (int zAxis = -this.range; zAxis <= this.range; ++zAxis) {
                            for (int yAxis = -this.rangeY; yAxis <= this.rangeY; ++yAxis) {
                                BlockPos blockpos = state.func_177982_a(i, k, j);
                                Block checkBlock = pos.func_180495_p(blockpos.func_177982_a(xAxis, yAxis, zAxis)).func_177230_c();
                                if (!(checkBlock instanceof IGrowable) && checkBlock != Blocks.field_150391_bh && checkBlock != Blocks.field_150434_aF && checkBlock != Blocks.field_150436_aH && checkBlock != Blocks.field_185766_cS) continue;
                                pos.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)state.func_177958_n() + 0.5, (double)state.func_177956_o() + 2.0, (double)state.func_177952_p() + 0.5, (double)((float)i + rand.nextFloat()) - 0.5, (double)((float)k - rand.nextFloat() - 1.0f), (double)((float)j + rand.nextFloat()) - 0.5, new int[0]);
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_176212_b(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return worldIn.func_180495_p(pos).func_185904_a().func_76220_a();
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return this.func_176196_c(worldIn, pos);
    }

    protected static void addCollisionBoxToList(BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable AxisAlignedBB blockBox) {
        AxisAlignedBB axisalignedbb;
        if (blockBox != field_185506_k && entityBox.func_72326_a(axisalignedbb = blockBox.func_186670_a(pos))) {
            collidingBoxes.add(axisalignedbb);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.growth_1", new Object[0]).func_150254_d());
        list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.growth_2", new Object[0]).func_150254_d());
        list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.growth_3", new Object[0]).func_150254_d());
    }
}

