/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.itemhandler;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;

public class DefaultSlotlessItemHandlerWrapper
implements ISlotlessItemHandler {
    private final IItemHandler itemHandler;

    public DefaultSlotlessItemHandlerWrapper(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if ((stack = this.itemHandler.insertItem(i, stack, simulate)) != null) continue;
            return null;
        }
        return stack;
    }

    @Override
    public ItemStack extractItem(int amount, boolean simulate) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack itemStack = this.itemHandler.extractItem(i, amount, simulate);
            if (itemStack == null) continue;
            return itemStack;
        }
        return null;
    }

    @Override
    public ItemStack extractItem(@Nonnull ItemStack matchStack, int matchFlags, boolean simulate) {
        boolean compareStackSize = (matchFlags & 4) > 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack itemStack = this.itemHandler.extractItem(i, compareStackSize ? matchStack.field_77994_a : matchStack.func_77976_d(), simulate);
            if (itemStack == null || !ItemMatch.areItemStacksEqual(matchStack, itemStack, matchFlags)) continue;
            return itemStack;
        }
        return null;
    }
}

