/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.snad.common.block;

import com.robrit.snad.common.item.IMetaBlockSnad;
import com.robrit.snad.common.util.ConfigurationData;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockReed;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockSnad
extends BlockFalling
implements IMetaBlockSnad {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockSnad() {
        super(Material.field_151595_p);
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185855_h);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_149663_c("snad");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.SAND)));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public MapColor func_180659_g(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMapColor();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)(meta == 0 ? EnumType.SAND : EnumType.RED_SAND)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        for (EnumType blockType : EnumType.values()) {
            list.add(new ItemStack(itemIn, 1, blockType.getMetadata()));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        Block blockAbove;
        if (!world.field_72995_K) {
            this.checkFallable(world, pos);
        }
        if ((blockAbove = world.func_180495_p(pos.func_177984_a()).func_177230_c()) == null) {
            return;
        }
        if (blockAbove instanceof BlockReed || blockAbove instanceof BlockCactus) {
            boolean isSameBlockType = true;
            int height = 1;
            while (isSameBlockType) {
                if (world.func_180495_p(pos.func_177981_b(height)).func_177230_c() != null) {
                    Block nextPlantBlock = world.func_180495_p(pos.func_177981_b(height)).func_177230_c();
                    if (nextPlantBlock.getClass() == blockAbove.getClass()) {
                        for (int growthAttempts = 0; growthAttempts < ConfigurationData.SPEED_INCREASE_VALUE; ++growthAttempts) {
                            if (!(growthAttempts == 0 | this.canSustainPlant(world.func_180495_p(pos), (IBlockAccess)world, pos, null, (IPlantable)blockAbove))) continue;
                            nextPlantBlock.func_180650_b(world, pos.func_177981_b(height), world.func_180495_p(pos.func_177981_b(height)), rand);
                        }
                        ++height;
                        continue;
                    }
                    isSameBlockType = false;
                    continue;
                }
                isSameBlockType = false;
            }
        } else if (blockAbove instanceof IPlantable) {
            blockAbove.func_180650_b(world, pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()), rand);
        }
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        if (BlockSnad.func_185759_i((IBlockState)worldIn.func_180495_p(pos.func_177977_b())) && pos.func_177956_o() >= 0) {
            int i = 32;
            if (!field_149832_M && worldIn.func_175707_a(pos.func_177982_a(-i, -i, -i), pos.func_177982_a(i, i, i))) {
                if (!worldIn.field_72995_K) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
                    this.func_149829_a(entityfallingblock);
                    worldIn.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                worldIn.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while (BlockSnad.func_185759_i((IBlockState)worldIn.func_180495_p(pos.func_177977_b())) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    worldIn.func_175656_a(blockpos.func_177984_a(), this.func_176223_P());
                }
            }
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        BlockPos plantPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
        Block plant = plantable.getPlant(world, plantPos).func_177230_c();
        EnumPlantType plantType = plantable.getPlantType(world, plantPos);
        switch (plantType) {
            case Desert: {
                return true;
            }
            case Water: {
                return world.func_180495_p(pos).func_177230_c().func_149688_o(world.func_180495_p(pos)) == Material.field_151586_h && world.func_180495_p(pos) == this.func_176223_P();
            }
            case Beach: {
                return world.func_180495_p(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p())).func_177230_c().func_149688_o(world.func_180495_p(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()))) == Material.field_151586_h || world.func_180495_p(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p())).func_177230_c().func_149688_o(world.func_180495_p(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()))) == Material.field_151586_h || world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1)).func_177230_c().func_149688_o(world.func_180495_p(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()))) == Material.field_151586_h || world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1)).func_177230_c().func_149688_o(world.func_180495_p(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()))) == Material.field_151586_h;
            }
        }
        return false;
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return stack.func_77952_i() == 0 ? "default" : "red";
    }

    public static enum EnumType implements IStringSerializable
    {
        SAND(0, "snad", "default", MapColor.field_151658_d),
        RED_SAND(1, "red_snad", "red", MapColor.field_151676_q);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor mapColor;
        private final String unlocalizedName;

        private EnumType(int meta, String name, String unlocalizedName, MapColor mapColor) {
            this.meta = meta;
            this.name = name;
            this.mapColor = mapColor;
            this.unlocalizedName = unlocalizedName;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockType;
                EnumType.META_LOOKUP[blockType.getMetadata()] = blockType = enumTypeArray[i];
            }
        }
    }
}

