/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraftforge.fml.common.Loader;

public enum EnumItemBrowser {
    NEI{

        @Override
        public boolean isValid() {
            return true;
        }
    }
    ,
    JEI{

        @Override
        public boolean isValid() {
            return Loader.isModLoaded((String)"JEI");
        }
    };


    public abstract boolean isValid();

    public static LinkedList<EnumItemBrowser> getValidBrowsers() {
        LinkedList<EnumItemBrowser> validBrowsers = new LinkedList<EnumItemBrowser>();
        for (EnumItemBrowser browser : EnumItemBrowser.values()) {
            if (!browser.isValid()) continue;
            validBrowsers.add(browser);
        }
        return validBrowsers;
    }

    public static ArrayList<EnumItemBrowser> toArray() {
        return Lists.newArrayList((Object[])EnumItemBrowser.values());
    }

    public static EnumItemBrowser getNext(EnumItemBrowser current) {
        LinkedList<EnumItemBrowser> validBrowsers = EnumItemBrowser.getValidBrowsers();
        EnumItemBrowser nextBrowser = validBrowsers.getFirst();
        int index = validBrowsers.indexOf((Object)current);
        if (index != -1) {
            try {
                nextBrowser = validBrowsers.get(index + 1);
            }
            catch (IndexOutOfBoundsException e) {
                nextBrowser = validBrowsers.getFirst();
            }
        }
        return nextBrowser;
    }
}

