/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.toolleveling.config;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.Item;
import slimeknights.mantle.config.AbstractConfigFile;
import slimeknights.mantle.configurate.objectmapping.Setting;
import slimeknights.mantle.configurate.objectmapping.serialize.ConfigSerializable;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.tools.harvest.TinkerHarvestTools;

@ConfigSerializable
public class ConfigFile
extends AbstractConfigFile {
    private static final int CONFIG_VERSION = 1;
    @Setting
    General general = new General();
    @Setting
    ToolXP toolxp = new ToolXP();

    public ConfigFile() {
    }

    public ConfigFile(File file) {
        super(file);
    }

    public int getConfigVersion() {
        return 1;
    }

    public void insertDefaults() {
        this.clearNeedsSaving();
        TinkerRegistry.getTools().stream().filter(tool -> !this.toolxp.baseXpForTool.containsKey(tool)).forEach(tool -> {
            this.toolxp.baseXpForTool.put((Item)tool, this.getDefaultXp((Item)tool));
            this.setNeedsSaving();
        });
    }

    private int getDefaultXp(Item item) {
        HashSet aoeTools = Sets.newHashSet((Object[])new Item[]{TinkerHarvestTools.hammer, TinkerHarvestTools.excavator, TinkerHarvestTools.lumberAxe});
        if (TinkerHarvestTools.scythe != null) {
            aoeTools.add(TinkerHarvestTools.scythe);
        }
        if (aoeTools.contains(item)) {
            return 9 * this.toolxp.defaultBaseXP;
        }
        return this.toolxp.defaultBaseXP;
    }

    @ConfigSerializable
    static class ToolXP {
        @Setting(comment="Base XP used when no more specific entry is present for the tool")
        public int defaultBaseXP = 500;
        @Setting(comment="Base XP for each of the listed tools")
        public Map<Item, Integer> baseXpForTool = new HashMap<Item, Integer>();
        public float levelMultiplier = 2.0f;

        ToolXP() {
        }
    }

    @ConfigSerializable
    static class General {
        @Setting(comment="Reduces the amount of modifiers a newly build tool gets if the value is lower than the regular amount of modifiers the tool would have")
        public int newToolMinModifiers = 3;
        @Setting(comment="Maximum achievable levels. If set to 0 or lower there is no upper limit")
        public int maximumLevels = -1;

        General() {
        }
    }
}

