/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import oreexcavation.client.ExcavationKeys;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import oreexcavation.handlers.EventHandler;
import oreexcavation.handlers.MiningScheduler;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.shapes.ShapeRegistry;
import org.apache.logging.log4j.Level;

public class PacketExcavation
implements IMessage {
    private NBTTagCompound tags = new NBTTagCompound();

    public PacketExcavation() {
    }

    public PacketExcavation(NBTTagCompound tags) {
        this.tags = tags;
    }

    public void fromBytes(ByteBuf buf) {
        this.tags = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tags);
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientHandler
    implements IMessageHandler<PacketExcavation, PacketExcavation> {
        public PacketExcavation onMessage(PacketExcavation message, MessageContext ctx) {
            if (ExcavationSettings.mineMode < 0) {
                return null;
            }
            if (ExcavationSettings.mineMode == 0 ? !ExcavationKeys.excavateKey.func_151470_d() : ExcavationSettings.mineMode != 2 && !Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
                return null;
            }
            EventHandler.isExcavating = true;
            ExcavateShape shape = ShapeRegistry.INSTANCE.getActiveShape();
            if (shape != null) {
                message.tags.func_74768_a("shape", shape.getShapeMask());
                message.tags.func_74768_a("depth", shape.getMaxDepth());
                message.tags.func_74768_a("origin", shape.getReticle());
            }
            return new PacketExcavation(message.tags);
        }
    }

    public static class ServerHandler
    implements IMessageHandler<PacketExcavation, PacketExcavation> {
        public PacketExcavation onMessage(PacketExcavation message, MessageContext ctx) {
            ExcavateShape shape;
            final EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player == null) {
                return null;
            }
            if (message.tags.func_74767_n("cancel")) {
                player.func_184102_h().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        MiningScheduler.INSTANCE.stopMining(player);
                    }
                });
                return null;
            }
            final int x = message.tags.func_74762_e("x");
            final int y = message.tags.func_74762_e("y");
            final int z = message.tags.func_74762_e("z");
            final IBlockState state = Block.func_176220_d((int)message.tags.func_74762_e("stateId"));
            if (state == null || state.func_177230_c() == Blocks.field_150350_a) {
                OreExcavation.logger.log(Level.INFO, "Recieved invalid block ID");
            }
            if (message.tags.func_74764_b("shape")) {
                if (!ExcavationSettings.allowShapes) {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Shape mining has been disabled"));
                    return null;
                }
                shape = new ExcavateShape();
                shape.setMask(message.tags.func_74762_e("shape"));
                if (message.tags.func_74764_b("depth")) {
                    shape.setMaxDepth(message.tags.func_74762_e("depth"));
                }
                if (message.tags.func_74764_b("origin")) {
                    int origin = message.tags.func_74762_e("origin");
                    shape.setReticle(origin % 5, origin / 5);
                }
            } else {
                shape = null;
            }
            player.func_184102_h().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    MiningScheduler.INSTANCE.startMining(player, new BlockPos(x, y, z), state, shape);
                }
            });
            return null;
        }
    }
}

