/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.integration.bop;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.api.generation.IGenerationManager;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.biome.vanilla.ExtendedBiomeWrapper;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.superckl.api.biometweaker.script.pack.IBiomePackage;
import me.superckl.api.biometweaker.script.wrapper.BTParameterTypes;
import me.superckl.api.superscript.ScriptCommandRegistry;
import me.superckl.api.superscript.command.ScriptCommandListing;
import me.superckl.api.superscript.util.ParameterTypes;
import me.superckl.api.superscript.util.ParameterWrapper;
import me.superckl.biometweaker.integration.IIntegrationModule;
import me.superckl.biometweaker.integration.bop.BOPReflectionHelper;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandAddBOPWorldType;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandAddSubBiomeBOP;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandAddToGenerationBOP;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandRemoveBOP;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandRemoveBOPWorldType;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandRemoveGeneratorBOP;
import me.superckl.biometweaker.integration.bop.script.ScriptCommandRemoveSubBiomeBOP;
import me.superckl.biometweaker.script.object.BiomesScriptObject;
import me.superckl.biometweaker.script.object.TweakerScriptObject;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.world.biome.Biome;

public class BOPIntegrationModule
implements IIntegrationModule {
    @Override
    public void preInit() {
        try {
            LogHelper.info("Registering BOP script commands...");
            ScriptCommandListing listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{ParameterTypes.STRING.getSimpleWrapper()}), ScriptCommandRemoveBOPWorldType.class.getDeclaredConstructor(String.class));
            ScriptCommandRegistry.INSTANCE.registerListing("removeExcludedBOPWorldType", listing, TweakerScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{ParameterTypes.STRING.getSimpleWrapper()}), ScriptCommandAddBOPWorldType.class.getDeclaredConstructor(String.class));
            ScriptCommandRegistry.INSTANCE.registerListing("addExcludedBOPWorldType", listing, TweakerScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper(), ParameterTypes.STRING.getSimpleWrapper(), ParameterTypes.NON_NEG_INTEGER.getSimpleWrapper()}), ScriptCommandAddToGenerationBOP.class.getDeclaredConstructor(IBiomePackage.class, String.class, Integer.TYPE));
            ScriptCommandRegistry.INSTANCE.registerListing("addToGenerationBOP", listing, TweakerScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper()}), ScriptCommandRemoveBOP.class.getDeclaredConstructor(IBiomePackage.class));
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper(), ParameterTypes.STRING.getSimpleWrapper()}), ScriptCommandRemoveBOP.class.getDeclaredConstructor(IBiomePackage.class, String.class));
            ScriptCommandRegistry.INSTANCE.registerListing("removeBOP", listing, TweakerScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper(), ParameterTypes.STRING.getSimpleWrapper()}), ScriptCommandRemoveGeneratorBOP.class.getDeclaredConstructor(IBiomePackage.class, String.class));
            ScriptCommandRegistry.INSTANCE.registerListing("removeGeneratorBOP", listing, TweakerScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper(), BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper()}), ScriptCommandAddSubBiomeBOP.class.getDeclaredConstructor(IBiomePackage.class, IBiomePackage.class));
            ScriptCommandRegistry.INSTANCE.registerListing("addSubBiomeBOP", listing, TweakerScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper(), BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper()}), ScriptCommandRemoveSubBiomeBOP.class.getDeclaredConstructor(IBiomePackage.class, IBiomePackage.class));
            ScriptCommandRegistry.INSTANCE.registerListing("removeSubBiomeBOP", listing, TweakerScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{ParameterTypes.STRING.getSimpleWrapper(), ParameterTypes.NON_NEG_INTEGER.getSimpleWrapper()}), ScriptCommandAddToGenerationBOP.class.getDeclaredConstructor(IBiomePackage.class, String.class, Integer.TYPE));
            ScriptCommandRegistry.INSTANCE.registerListing("addToGenerationBOP", listing, BiomesScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(new ArrayList<ParameterWrapper>(), ScriptCommandRemoveBOP.class.getDeclaredConstructor(IBiomePackage.class));
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{ParameterTypes.STRING.getSimpleWrapper()}), ScriptCommandRemoveBOP.class.getDeclaredConstructor(IBiomePackage.class, String.class));
            ScriptCommandRegistry.INSTANCE.registerListing("removeBOP", listing, BiomesScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{ParameterTypes.STRING.getSimpleWrapper()}), ScriptCommandRemoveGeneratorBOP.class.getDeclaredConstructor(IBiomePackage.class, String.class));
            ScriptCommandRegistry.INSTANCE.registerListing("removeGeneratorBOP", listing, BiomesScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper()}), ScriptCommandAddSubBiomeBOP.class.getDeclaredConstructor(IBiomePackage.class, IBiomePackage.class));
            ScriptCommandRegistry.INSTANCE.registerListing("addSubBiomeBOP", listing, BiomesScriptObject.class);
            listing = new ScriptCommandListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getSimpleWrapper()}), ScriptCommandRemoveSubBiomeBOP.class.getDeclaredConstructor(IBiomePackage.class, IBiomePackage.class));
            ScriptCommandRegistry.INSTANCE.registerListing("removeSubBiomeBOP", listing, BiomesScriptObject.class);
        }
        catch (Exception e) {
            LogHelper.error("Failed to register BOP script commands! Some commands may not work properly!");
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    @Override
    public String getName() {
        return "Biomes O' Plenty Integration";
    }

    public static IExtendedBiome getExtendedBiome(Biome biome) {
        IExtendedBiome eBiome = BOPBiomes.REG_INSTANCE.getExtendedBiome(biome);
        if (eBiome == null) {
            eBiome = new ExtendedBiomeWrapper(biome);
            BOPBiomes.REG_INSTANCE.registerBiome(eBiome, eBiome.getBaseBiome().field_76791_y.toLowerCase());
        }
        return eBiome;
    }

    @Override
    public void addBiomeInfo(Biome biome, JsonObject obj) {
        IExtendedBiome eBiome = BOPIntegrationModule.getExtendedBiome(biome);
        biome = eBiome.getBaseBiome();
        IGenerationManager gManager = eBiome.getGenerationManager();
        JsonObject genNames = new JsonObject();
        for (GeneratorStage stage : GeneratorStage.values()) {
            ImmutableCollection gens = gManager.getGeneratorsForStage(stage);
            if (gens.isEmpty()) continue;
            JsonArray subArray = new JsonArray();
            Iterator it = gens.iterator();
            while (it.hasNext()) {
                JsonObject subSubObj = new JsonObject();
                IGenerator gen = (IGenerator)it.next();
                subSubObj.addProperty("ID", gen.getIdentifier());
                subSubObj.addProperty("Name", gen.getName());
                subArray.add((JsonElement)subSubObj);
            }
            genNames.add(stage.name() + " Generators", (JsonElement)subArray);
        }
        obj.add("BOP Generators", (JsonElement)genNames);
        obj.addProperty("BOP Owner", eBiome.getBiomeOwner().name());
        Gson gson = new Gson();
        obj.add("BOP Weight Map", gson.toJsonTree((Object)eBiome.getWeightMap()));
        try {
            BOPReflectionHelper.reflectFields();
            JsonObject weights = new JsonObject();
            for (BOPClimates climate : BOPClimates.values()) {
                List entries = (List)BOPReflectionHelper.landBiomes.get(climate);
                JsonArray subArray = new JsonArray();
                for (BOPClimates.WeightedBiomeEntry entry : entries) {
                    if (Biome.func_185362_a((Biome)entry.biome) != Biome.func_185362_a((Biome)biome)) continue;
                    subArray.add((JsonElement)new JsonPrimitive((Number)entry.weight));
                }
                if (subArray.size() <= 0) continue;
                weights.add(climate.name(), (JsonElement)subArray);
            }
            obj.add("BOP Climate Weights", (JsonElement)weights);
        }
        catch (Exception e) {
            LogHelper.error("Failed to retrieve all BOP biome info!");
            e.printStackTrace();
        }
    }
}

