/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.handler;

import com.google.common.collect.Maps;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.custom_hash.TObjectByteCustomHashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.superckl.biometweaker.common.world.gen.layer.GenLayerReplacement;
import me.superckl.biometweaker.core.BiomeTweakerCore;
import me.superckl.biometweaker.util.LogHelper;
import me.superckl.biometweaker.util.NumberHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeEventHandler {
    public static byte globalSize = (byte)-1;
    public static final TObjectByteCustomHashMap<Object> sizes = new TObjectByteCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE);
    private static final TIntObjectMap<List<Pair<Pair<Block, Integer>, List<WeightedBlockEntry>>>> blockReplacements = new TIntObjectHashMap();
    private static final TIntObjectMap<List<Pair<Pair<Block, Integer>, Pair<Block, Integer>>>> villageBlockReplacements = new TIntObjectHashMap();
    private static final boolean[] contigReplaces = new boolean[256];
    private static final TIntIntMap biomeReplacements = new TIntIntHashMap();
    private static final TIntObjectMap<List<String>> decorateTypes = new TIntObjectHashMap();
    private static final TIntObjectMap<List<String>> populateTypes = new TIntObjectHashMap();
    private static final TIntIntMap waterlilyPerChunk = new TIntIntHashMap();
    private static final TIntIntMap treesPerChunk = new TIntIntHashMap();
    private static final TIntIntMap flowersPerChunk = new TIntIntHashMap();
    private static final TIntIntMap grassPerChunk = new TIntIntHashMap();
    private static final TIntIntMap deadBushPerChunk = new TIntIntHashMap();
    private static final TIntIntMap mushroomPerChunk = new TIntIntHashMap();
    private static final TIntIntMap reedsPerChunk = new TIntIntHashMap();
    private static final TIntIntMap cactiPerChunk = new TIntIntHashMap();
    private static final TIntIntMap sandPerChunk = new TIntIntHashMap();
    private static final TIntIntMap clayPerChunk = new TIntIntHashMap();
    private static final TIntIntMap bigMushroomsPerChunk = new TIntIntHashMap();
    private Field grassColor;
    private Field foliageColor;
    private final int[] colorCache = new int[512];
    private final Map<World, Map<ChunkPos, TIntObjectMap<Map<Block, TIntObjectMap<WeightedBlockEntry>>>>> replacedBiomes = Maps.newHashMap();

    public BiomeEventHandler() {
        Arrays.fill(this.colorCache, -2);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onReplaceBlocks(ChunkGeneratorEvent.ReplaceBiomeBlocks e) {
        try {
            if (!this.replacedBiomes.containsKey(e.getWorld())) {
                this.replacedBiomes.put(e.getWorld(), Maps.newHashMap());
            }
            if (blockReplacements.isEmpty()) {
                return;
            }
            TIntObjectMap<Map<Block, TIntObjectMap<WeightedBlockEntry>>> shouldDoBMap = this.findMap(e.getWorld(), new ChunkPos(e.getX(), e.getZ()));
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Biome biomegenbase = e.getWorld().func_180494_b(new BlockPos(e.getX() << 4, 0, e.getZ() << 4));
                    int id = Biome.func_185362_a((Biome)biomegenbase);
                    if (!blockReplacements.containsKey(id)) continue;
                    if (!shouldDoBMap.containsKey(id)) {
                        shouldDoBMap.put(id, (Object)Maps.newIdentityHashMap());
                    }
                    Map shouldDoMap = (Map)shouldDoBMap.get(id);
                    List list = (List)blockReplacements.get(id);
                    int k1 = 256;
                    for (int y = 0; y < 256; ++y) {
                        Integer meta;
                        IBlockState state = e.getPrimer().func_177856_a(x, y, z);
                        Block block = state.func_177230_c();
                        WeightedBlockEntry toUse = null;
                        if (shouldDoMap.containsKey(block)) {
                            TIntObjectMap map = (TIntObjectMap)shouldDoMap.get(block);
                            if (map.containsKey(block.func_176201_c(state))) {
                                toUse = (WeightedBlockEntry)((Object)map.get(block.func_176201_c(state)));
                            } else if (map.containsKey(-1)) {
                                toUse = (WeightedBlockEntry)((Object)map.get(-1));
                            }
                        }
                        if (toUse == null) {
                            for (Pair pair : list) {
                                boolean shouldDo;
                                if (((Pair)pair.getKey()).getKey() != block || !(shouldDo = (meta = (Integer)((Pair)pair.getKey()).getValue()) == null || block.func_176201_c(state) == meta.intValue())) continue;
                                toUse = (WeightedBlockEntry)WeightedRandom.func_76271_a((Random)e.getWorld().field_73012_v, (List)((List)pair.getValue()));
                                if (!shouldDoMap.containsKey(block)) {
                                    shouldDoMap.put(block, new TIntObjectHashMap());
                                }
                                TIntObjectMap map = (TIntObjectMap)shouldDoMap.get(block);
                                map.put(meta == null ? -1 : meta, (Object)toUse);
                            }
                        }
                        if (toUse == null) continue;
                        Block block2 = (Block)toUse.block.getKey();
                        meta = (Integer)toUse.block.getValue();
                        e.getPrimer().func_177855_a(x, y, z, meta == null ? block2.func_176223_P() : block2.func_176203_a(meta.intValue()));
                    }
                }
            }
            TIntIterator it = shouldDoBMap.keySet().iterator();
            while (it.hasNext()) {
                if (contigReplaces[it.next()]) continue;
                it.remove();
            }
            this.replacedBiomes.get(e.getWorld()).put(new ChunkPos(e.getX(), e.getZ()), shouldDoBMap);
        }
        catch (Exception e1) {
            LogHelper.error("Failed to process replace biome blocks event.");
            e1.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGetGrassColor(BiomeEvent.GetGrassColor e) {
        try {
            int id;
            int newColor;
            if (this.grassColor == null) {
                this.grassColor = Biome.class.getDeclaredField("grassColor");
            }
            if ((newColor = this.colorCache[id = Biome.func_185362_a((Biome)e.getBiome())]) == -1) {
                return;
            }
            newColor = this.colorCache[id];
            if (newColor != -2) {
                e.setNewColor(newColor);
            } else {
                this.colorCache[id] = newColor = this.grassColor.getInt(e.getBiome());
                if (newColor == -1) {
                    return;
                }
                e.setNewColor(newColor);
            }
        }
        catch (Exception e1) {
            LogHelper.error("Failed to process getGrassColor event!");
            e1.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGetFoliageColor(BiomeEvent.GetFoliageColor e) {
        try {
            int id;
            int newColor;
            if (this.foliageColor == null) {
                this.foliageColor = Biome.class.getDeclaredField("foliageColor");
            }
            if ((newColor = this.colorCache[(id = Biome.func_185362_a((Biome)e.getBiome())) + 256]) == -1) {
                return;
            }
            newColor = this.colorCache[id + 256];
            if (newColor != -2) {
                e.setNewColor(newColor);
            } else {
                this.colorCache[id + 256] = newColor = this.foliageColor.getInt(e.getBiome());
                if (newColor == -1) {
                    return;
                }
                e.setNewColor(newColor);
            }
        }
        catch (Exception e1) {
            LogHelper.error("Failed to process getFoliageColor event!");
            e1.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeDecorate(DecorateBiomeEvent.Decorate e) {
        if (decorateTypes.isEmpty()) {
            return;
        }
        Biome gen = e.getWorld().func_180494_b(e.getPos());
        boolean isAll = decorateTypes.containsKey(-1);
        if ((isAll || decorateTypes.containsKey(Biome.func_185362_a((Biome)gen))) && (((List)decorateTypes.get(isAll ? -1 : Biome.func_185362_a((Biome)gen))).contains(e.getType().name()) || ((List)decorateTypes.get(isAll ? -1 : Biome.func_185362_a((Biome)gen))).contains("all"))) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomePopulate(PopulateChunkEvent.Populate e) {
        if (populateTypes.isEmpty()) {
            return;
        }
        Biome gen = e.getWorld().func_180494_b(new BlockPos(e.getChunkX(), 0, e.getChunkZ()));
        boolean isAll = populateTypes.containsKey(-1);
        if ((isAll || populateTypes.containsKey(Biome.func_185362_a((Biome)gen))) && (((List)populateTypes.get(isAll ? -1 : Biome.func_185362_a((Biome)gen))).contains(e.getType().name()) || ((List)populateTypes.get(isAll ? -1 : Biome.func_185362_a((Biome)gen))).contains("all"))) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onCreateBiomeDecorator(BiomeEvent.CreateDecorator e) {
        int id = Biome.func_185362_a((Biome)e.getBiome());
        if (waterlilyPerChunk.containsKey(id)) {
            e.getNewBiomeDecorator().field_76833_y = waterlilyPerChunk.get(id);
        }
        if (treesPerChunk.containsKey(id)) {
            e.getNewBiomeDecorator().field_76832_z = treesPerChunk.get(id);
        }
        if (flowersPerChunk.containsKey(id)) {
            e.getNewBiomeDecorator().field_76802_A = flowersPerChunk.get(id);
        }
        if (grassPerChunk.containsKey(id)) {
            e.getNewBiomeDecorator().field_76803_B = grassPerChunk.get(id);
        }
        if (deadBushPerChunk.containsKey(id)) {
            e.getNewBiomeDecorator().field_76804_C = deadBushPerChunk.get(id);
        }
        if (mushroomPerChunk.containsKey(id)) {
            e.getNewBiomeDecorator().field_76798_D = mushroomPerChunk.get(id);
        }
        if (reedsPerChunk.containsKey(id)) {
            e.getNewBiomeDecorator().field_76799_E = reedsPerChunk.get(id);
        }
        if (cactiPerChunk.containsKey(id)) {
            e.getNewBiomeDecorator().field_76800_F = cactiPerChunk.get(id);
        }
        if (sandPerChunk.containsKey(id)) {
            e.getNewBiomeDecorator().field_76801_G = sandPerChunk.get(id);
        }
        if (clayPerChunk.containsKey(id)) {
            e.getNewBiomeDecorator().field_76806_I = clayPerChunk.get(id);
        }
        if (bigMushroomsPerChunk.containsKey(id)) {
            e.getNewBiomeDecorator().field_76807_J = bigMushroomsPerChunk.get(id);
        }
    }

    @SubscribeEvent
    public void onGetBiomeSize(WorldTypeEvent.BiomeSize e) {
        if (globalSize != -1) {
            e.setNewSize((int)globalSize);
        } else if (sizes.containsKey((Object)e.getWorldType())) {
            e.setNewSize((int)sizes.get((Object)e.getWorldType()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onInitBiomeGens(WorldTypeEvent.InitBiomeGens e) {
        e.getNewBiomeGens()[0] = new GenLayerReplacement(e.getNewBiomeGens()[0]);
        e.getNewBiomeGens()[1] = new GenLayerReplacement(e.getNewBiomeGens()[1]);
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void onReplaceVillageBlockID(BiomeEvent.GetVillageBlockID e) {
        if (e.getBiome() == null || e.getOriginal() == null) {
            return;
        }
        List list = (List)villageBlockReplacements.get(Biome.func_185362_a((Biome)e.getBiome()));
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Pair fPair : list) {
            boolean shouldDo;
            if (((Pair)fPair.getKey()).getKey() != (e.getReplacement() == null ? e.getOriginal().func_177230_c() : e.getReplacement().func_177230_c())) continue;
            Integer meta = (Integer)((Pair)fPair.getKey()).getValue();
            boolean bl = shouldDo = meta == null;
            if (!shouldDo) {
                boolean bl2 = shouldDo = meta.intValue() == ((Block)((Pair)fPair.getKey()).getKey()).func_176201_c(e.getReplacement() == null ? e.getOriginal() : e.getReplacement());
            }
            if (!shouldDo) continue;
            meta = (Integer)((Pair)fPair.getValue()).getValue();
            e.setReplacement(((Block)((Pair)fPair.getValue()).getKey()).func_176203_a(meta == null ? 0 : meta));
            e.setResult(Event.Result.DENY);
            break;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldEvent.Load e) {
        if (!BiomeTweakerCore.modifySuccess) {
            boolean cont = StartupQuery.confirm((String)"WARNING\n\nBiomeTweaker has failed to verify the integrity of its ASM modifications.\n This could cause some features to not work or spam errors,\n leading to unpredicatable world generation and possibly corruption.\n Please report this to the issue tracker with a full log file.\n\nhttps://github.com/superckl/BiomeTweaker/issues\n\nContinue anyway?");
            if (cont) {
                BiomeTweakerCore.modifySuccess = true;
            } else {
                FMLCommonHandler.instance().exitJava(1, false);
            }
        }
    }

    private TIntObjectMap<Map<Block, TIntObjectMap<WeightedBlockEntry>>> findMap(World world, ChunkPos pair) {
        ChunkPos[] pairs;
        Map<ChunkPos, TIntObjectMap<Map<Block, TIntObjectMap<WeightedBlockEntry>>>> map = this.replacedBiomes.get(world);
        for (ChunkPos search : pairs = NumberHelper.fillGrid(4, pair)) {
            if (!map.containsKey(search)) continue;
            return map.get(search);
        }
        return new TIntObjectHashMap();
    }

    public static TIntObjectMap<List<Pair<Pair<Block, Integer>, List<WeightedBlockEntry>>>> getBlockReplacements() {
        return blockReplacements;
    }

    public static TIntObjectMap<List<Pair<Pair<Block, Integer>, Pair<Block, Integer>>>> getVillageBlockReplacements() {
        return villageBlockReplacements;
    }

    public static boolean[] getContigReplaces() {
        return contigReplaces;
    }

    public static TIntIntMap getBiomeReplacements() {
        return biomeReplacements;
    }

    public static TIntObjectMap<List<String>> getDecorateTypes() {
        return decorateTypes;
    }

    public static TIntObjectMap<List<String>> getPopulateTypes() {
        return populateTypes;
    }

    public static TIntIntMap getWaterlilyPerChunk() {
        return waterlilyPerChunk;
    }

    public static TIntIntMap getTreesPerChunk() {
        return treesPerChunk;
    }

    public static TIntIntMap getFlowersPerChunk() {
        return flowersPerChunk;
    }

    public static TIntIntMap getGrassPerChunk() {
        return grassPerChunk;
    }

    public static TIntIntMap getDeadBushPerChunk() {
        return deadBushPerChunk;
    }

    public static TIntIntMap getMushroomPerChunk() {
        return mushroomPerChunk;
    }

    public static TIntIntMap getReedsPerChunk() {
        return reedsPerChunk;
    }

    public static TIntIntMap getCactiPerChunk() {
        return cactiPerChunk;
    }

    public static TIntIntMap getSandPerChunk() {
        return sandPerChunk;
    }

    public static TIntIntMap getClayPerChunk() {
        return clayPerChunk;
    }

    public static TIntIntMap getBigMushroomsPerChunk() {
        return bigMushroomsPerChunk;
    }

    public static class WeightedBlockEntry
    extends WeightedRandom.Item {
        private final Pair<Block, Integer> block;

        public WeightedBlockEntry(int weight, Pair<Block, Integer> block) {
            super(weight);
            this.block = block;
        }

        public Pair<Block, Integer> getBlock() {
            return this.block;
        }
    }
}

