/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.client.gui;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import me.superckl.biometweaker.config.Config;
import me.superckl.biometweaker.core.BiomeTweakerCore;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ReloadScriptsConfigEntry
extends GuiConfigEntries.ButtonEntry {
    private boolean youSure;
    private int pressedCounter;

    public ReloadScriptsConfigEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
        super(owningScreen, owningEntryList, configElement);
        this.btnValue.field_146126_j = "Reload Scripts";
    }

    public void updateValueButtonText() {
        this.btnValue.field_146126_j = this.youSure ? "Are you sure?" : "Reload Scripts";
    }

    public void drawToolTip(int mouseX, int mouseY) {
        if (this.pressedCounter-- > 0) {
            this.owningScreen.drawToolTip((List)Lists.newArrayList((Object[])new String[]{TextFormatting.AQUA + "Scripts reloaded.", TextFormatting.RED + "Don't spam the button!"}), mouseX, mouseY);
        } else {
            super.drawToolTip(mouseX, mouseY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueButtonPressed(int slotIndex) {
        if (this.pressedCounter > 0) {
            return;
        }
        if (this.youSure) {
            try {
                File operateIn = new File(BiomeTweakerCore.mcLocation, "config/BiomeTweaker/");
                File mainConfig = new File(operateIn, "BiomeTweaker.cfg");
                BufferedReader reader = new BufferedReader(new FileReader(mainConfig));
                try {
                    JsonObject obj = (JsonObject)new JsonParser().parse((Reader)reader);
                    if (obj.entrySet().isEmpty()) {
                        LogHelper.warn("The configuration file read as empty! BiomeTweaker isn't going to do anything.");
                    }
                    Config.INSTANCE.init(operateIn, obj);
                    this.pressedCounter = 200;
                }
                finally {
                    if (Collections.singletonList(reader).get(0) != null) {
                        reader.close();
                    }
                }
            }
            catch (Exception e) {
                LogHelper.error("Failed to reload scripts!");
                e.printStackTrace();
            }
        }
        this.youSure = !this.youSure;
    }

    public boolean isDefault() {
        return !this.youSure;
    }

    public void setToDefault() {
        this.youSure = false;
        this.btnValue.field_146126_j = "Reload Scripts";
    }

    public boolean isChanged() {
        return this.youSure;
    }

    public void undoChanges() {
        this.youSure = false;
        this.btnValue.field_146126_j = "Reload Scripts";
    }

    public boolean saveConfigElement() {
        return false;
    }

    public Object getCurrentValue() {
        return null;
    }

    public Object[] getCurrentValues() {
        return null;
    }

    public void func_178011_a(int p_178011_1_, int p_178011_2_, int p_178011_3_) {
    }
}

