/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.superckl.api.superscript.APIInfo;
import me.superckl.api.superscript.command.IScriptCommand;
import net.minecraftforge.common.util.EnumHelper;

public class ScriptCommandManager {
    private static Map<String, ScriptCommandManager> instances = Maps.newHashMap();
    private static ApplicationStage defaultStage = ApplicationStage.FINISHED_LOAD;
    private ApplicationStage currentStage = defaultStage;
    private final Map<ApplicationStage, List<IScriptCommand>> commands = Maps.newEnumMap(ApplicationStage.class);
    private final Set<ApplicationStage> appliedStages = EnumSet.noneOf(ApplicationStage.class);

    protected ScriptCommandManager() {
    }

    public boolean addCommand(IScriptCommand command) {
        if (!this.commands.containsKey((Object)this.currentStage)) {
            this.commands.put(this.currentStage, new ArrayList());
        }
        if (this.appliedStages.contains((Object)this.currentStage)) {
            try {
                command.perform();
            }
            catch (Exception e) {
                APIInfo.log.error("Failed to execute script command: " + command);
                e.printStackTrace();
            }
        }
        return this.commands.get((Object)this.currentStage).add(command);
    }

    public void applyCommandsFor(ApplicationStage stage) {
        if (!this.commands.containsKey((Object)stage)) {
            return;
        }
        this.appliedStages.add(stage);
        List<IScriptCommand> commands = this.commands.get((Object)stage);
        APIInfo.log.info("Found " + commands.size() + " tweak" + (commands.size() > 1 ? "s" : "") + " to apply for stage " + stage.toString() + ". Applying...");
        for (IScriptCommand command : commands) {
            try {
                command.perform();
            }
            catch (Exception e) {
                APIInfo.log.error("Failed to execute script command: " + command);
                e.printStackTrace();
            }
        }
    }

    public void reset() {
        this.commands.clear();
        this.currentStage = defaultStage;
    }

    public static ScriptCommandManager newInstance(String owner) {
        ScriptCommandManager manager = new ScriptCommandManager();
        instances.put(owner, manager);
        return manager;
    }

    public static ScriptCommandManager getManagerFor(String owner) {
        return instances.get(owner);
    }

    public ApplicationStage getCurrentStage() {
        return this.currentStage;
    }

    public void setCurrentStage(ApplicationStage currentStage) {
        this.currentStage = currentStage;
    }

    public Map<ApplicationStage, List<IScriptCommand>> getCommands() {
        return this.commands;
    }

    public Set<ApplicationStage> getAppliedStages() {
        return this.appliedStages;
    }

    public static ApplicationStage getDefaultStage() {
        return defaultStage;
    }

    public static void setDefaultStage(ApplicationStage defaultStage) {
        ScriptCommandManager.defaultStage = defaultStage;
    }

    public static enum ApplicationStage {
        PRE_INIT,
        INIT,
        POST_INIT,
        FINISHED_LOAD,
        SERVER_STARTING,
        SERVER_STARTED;


        public static ApplicationStage newStage(String name) {
            return (ApplicationStage)EnumHelper.addEnum(ApplicationStage.class, (String)name, (Class[])new Class[0], (Object[])new Object[0]);
        }
    }
}

