/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.overworld;

import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.IPlantable;

public class OverworldTreeGenerator
extends BaseTreeGenerator {
    public final int minTreeHeight;
    public final int treeHeightRange;
    public final IBlockState log;
    public final IBlockState leaves;
    public final boolean seekHeight;
    public final boolean isSapling;

    public OverworldTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, boolean seekHeight, boolean isSapling) {
        this.minTreeHeight = treeHeight;
        this.treeHeightRange = treeRange;
        this.log = log;
        this.leaves = leaves;
        this.seekHeight = seekHeight;
        this.isSapling = isSapling;
    }

    public OverworldTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves) {
        this(treeHeight, treeRange, log, leaves, true, false);
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    @Override
    public void generateTree(Random rand, World worldIn, BlockPos position) {
        int heightRange = rand.nextInt(this.treeHeightRange) + this.minTreeHeight;
        if (this.seekHeight && (position = this.findGround(worldIn, position)).func_177956_o() < 0) {
            return;
        }
        if (position.func_177956_o() >= 1 && position.func_177956_o() + heightRange + 1 <= 256) {
            boolean isSoil;
            IBlockState state = worldIn.func_180495_p(position.func_177977_b());
            Block soil = state.func_177230_c();
            boolean bl = isSoil = soil != null && soil.canSustainPlant(state, (IBlockAccess)worldIn, position.func_177977_b(), EnumFacing.UP, (IPlantable)NaturaOverworld.overworldSapling);
            if (isSoil) {
                if (!this.checkIfCanGrow(position, heightRange, worldIn)) {
                    return;
                }
                soil.onPlantGrow(state, worldIn, position.func_177977_b(), position);
                this.placeCanopy(worldIn, rand, position, heightRange);
                this.placeTrunk(worldIn, position, heightRange);
            }
        }
    }

    private boolean checkIfCanGrow(BlockPos position, int heightRange, World worldIn) {
        boolean canGrowTree = true;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        for (int y = position.func_177956_o(); y <= position.func_177956_o() + 1 + heightRange; ++y) {
            int range = 1;
            if (y == position.func_177956_o()) {
                range = 0;
            }
            if (y >= position.func_177956_o() + 1 + heightRange - 2) {
                range = 2;
            }
            for (int x = position.func_177958_n() - range; x <= position.func_177958_n() + range && canGrowTree; ++x) {
                for (int z = position.func_177952_p() - range; z <= position.func_177952_p() + range && canGrowTree; ++z) {
                    if (y >= 0 && y < worldIn.func_72940_L()) {
                        pos.func_181079_c(x, y, z);
                        IBlockState state = worldIn.func_180495_p((BlockPos)pos);
                        Block block = state.func_177230_c();
                        if ((block == null || block == NaturaOverworld.overworldSapling) && block.isLeaves(state, (IBlockAccess)worldIn, (BlockPos)pos)) continue;
                        canGrowTree = true;
                        continue;
                    }
                    canGrowTree = true;
                }
            }
        }
        return canGrowTree;
    }

    BlockPos findGround(World world, BlockPos pos) {
        int returnHeight = 0;
        int height = pos.func_177956_o();
        if (world.func_175624_G() == WorldType.field_77138_c && this.isSapling) {
            do {
                BlockPos position;
                Block block;
                if ((block = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p())).func_177230_c()) != Blocks.field_150346_d && block != Blocks.field_150349_c || world.func_180495_p(position.func_177984_a()).func_185913_b()) continue;
                returnHeight = height + 1;
                break;
            } while (--height > Config.flatSeaLevel);
            return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
        }
        do {
            BlockPos position;
            Block block;
            if ((block = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p())).func_177230_c()) != Blocks.field_150346_d && block != Blocks.field_150349_c || world.func_180495_p(position.func_177984_a()).func_185913_b()) continue;
            returnHeight = height + 1;
            break;
        } while (--height > Config.seaLevel);
        return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
    }

    protected void placeCanopy(World world, Random random, BlockPos pos, int height) {
        for (int y = pos.func_177956_o() - 3 + height; y <= pos.func_177956_o() + height; ++y) {
            int subract = y - (pos.func_177956_o() + height);
            int subract2 = 1 - subract / 2;
            for (int x = pos.func_177958_n() - subract2; x <= pos.func_177958_n() + subract2; ++x) {
                int mathX = x - pos.func_177958_n();
                for (int z = pos.func_177952_p() - subract2; z <= pos.func_177952_p() + subract2; ++z) {
                    BlockPos blockpos;
                    IBlockState state;
                    int mathZ = z - pos.func_177952_p();
                    if (Math.abs(mathX) == subract2 && Math.abs(mathZ) == subract2 && (random.nextInt(2) == 0 || subract == 0) || !(state = world.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, blockpos) && !state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, blockpos)) continue;
                    world.func_180501_a(blockpos, this.leaves, 2);
                }
            }
        }
    }

    protected boolean canGrowInto(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151584_j || blockType == Blocks.field_150349_c || blockType == Blocks.field_150346_d || blockType == Blocks.field_150364_r || blockType == Blocks.field_150363_s || blockType == Blocks.field_150345_g || blockType == Blocks.field_150395_bd;
    }

    protected void placeTrunk(World world, BlockPos pos, int height) {
        for (int localHeight = 0; localHeight < height; ++localHeight) {
            BlockPos blockpos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + localHeight, pos.func_177952_p());
            IBlockState state = world.func_180495_p(blockpos);
            Block block = state.func_177230_c();
            if (block != null && !block.isAir(state, (IBlockAccess)world, blockpos) && !block.isLeaves(state, (IBlockAccess)world, blockpos) && !block.func_176200_f((IBlockAccess)world, blockpos)) continue;
            world.func_180501_a(blockpos, this.log, 2);
        }
    }
}

