/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public final class Utils {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    private Utils() {
    }

    public static MethodHandle getMethodHandle(String className, String name, Class<?> ... parameterTypes) {
        try {
            return Utils.getMethodHandle(Class.forName(className, false, Utils.class.getClassLoader()), name, parameterTypes);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionHelper.UnableToFindMethodException(new String[]{name}, (Exception)e);
        }
    }

    public static MethodHandle getMethodHandle(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return LOOKUP.unreflect(method);
        }
        catch (Exception e) {
            throw new ReflectionHelper.UnableToFindMethodException(new String[]{name}, e);
        }
    }

    public static Field getFieldOfType(Class<?> clazz, Class<?> type) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getType().equals(type)) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    public static <E extends Enum<E>> E getEnumValue(Class<E> clazz, int ordinal) {
        Enum[] values = (Enum[])Objects.requireNonNull(clazz, "clazz").getEnumConstants();
        return (E)values[ordinal < 0 || ordinal >= values.length ? 0 : ordinal];
    }

    public static String formatColored(EnumDyeColor color, String name) {
        return I18n.func_74837_a((String)"format.colored", (Object[])new Object[]{I18n.func_74838_a((String)("color." + color.func_176762_d() + ".name")), name});
    }

    public static String formatRecipeTooltip(String key) {
        return Utils.formatRecipeTooltipValue(I18n.func_74838_a((String)key));
    }

    public static String formatRecipeTooltipValue(String value) {
        return I18n.func_74837_a((String)"recipe.ingredient.tooltip", (Object[])new Object[]{value});
    }

    public static String getEntityName(Entity e) {
        if (e.func_145818_k_()) {
            return e.func_95999_t();
        }
        String s = EntityList.func_75621_b((Entity)e);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity.fairylights." + s + ".name"));
    }

    public static ImmutableList<ItemStack> copyItemStacks(List<ItemStack> list) {
        ImmutableList.Builder copy = ImmutableList.builder();
        for (ItemStack stack : list) {
            copy.add((Object)stack.func_77946_l());
        }
        return copy.build();
    }
}

