/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import com.google.common.collect.ImmutableList;
import com.pau101.fairylights.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictUtils {
    private static final String[] DYE_NAMES = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
    @Nullable
    private static List<ItemStack>[] dyeItemStacks;
    @Nullable
    private static List<ItemStack> allDyeItemStacks;

    private OreDictUtils() {
    }

    public static boolean isDye(@Nullable ItemStack stack) {
        if (stack != null) {
            if (stack.func_77973_b() == Items.field_151100_aR) {
                return true;
            }
            OreDictUtils.initDyeItemStacks();
            for (ItemStack dye : allDyeItemStacks) {
                if (!OreDictionary.itemMatches((ItemStack)dye, (ItemStack)stack, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getDyeMetadata(@Nullable ItemStack stack) {
        if (stack != null) {
            if (stack.func_77973_b() == Items.field_151100_aR) {
                return stack.func_77960_j();
            }
            OreDictUtils.initDyeItemStacks();
            for (int i = 0; i < DYE_NAMES.length; ++i) {
                List<ItemStack> dyes = dyeItemStacks[i];
                for (ItemStack dye : dyes) {
                    if (!OreDictionary.itemMatches((ItemStack)dye, (ItemStack)stack, (boolean)false)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public static ImmutableList<ItemStack> getDyes(EnumDyeColor color) {
        OreDictUtils.initDyeItemStacks();
        return Utils.copyItemStacks(dyeItemStacks[color.func_176767_b()]);
    }

    public static ImmutableList<ItemStack> getAllDyes() {
        OreDictUtils.initDyeItemStacks();
        return Utils.copyItemStacks(allDyeItemStacks);
    }

    public static boolean matches(ItemStack stack, String name) {
        return OreDictionary.containsMatch((boolean)false, (List)OreDictionary.getOres((String)name), (ItemStack[])new ItemStack[]{stack});
    }

    private static void initDyeItemStacks() {
        if (dyeItemStacks == null) {
            dyeItemStacks = new List[DYE_NAMES.length];
            allDyeItemStacks = new ArrayList<ItemStack>();
            for (int i = 0; i < DYE_NAMES.length; ++i) {
                OreDictUtils.dyeItemStacks[i] = new ArrayList<ItemStack>(OreDictionary.getOres((String)DYE_NAMES[i]));
                allDyeItemStacks.addAll(dyeItemStacks[i]);
            }
        }
    }
}

