/*
 * Decompiled with CFR 0.152.
 */
package turkey.witherCrumbs.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;
import turkey.witherCrumbs.WitherCrumbsCore;
import turkey.witherCrumbs.info.CelebrityWitherRegistry;
import turkey.witherCrumbs.items.WitherCrumbsItems;

public class CustomWitherLoader {
    public static CustomWitherLoader instance;
    private JsonParser json;
    private File file;

    public CustomWitherLoader(File file) {
        instance = this;
        this.json = new JsonParser();
        this.file = file;
    }

    public void loadCustomWithers() {
        JsonElement fileJson;
        try {
            fileJson = this.json.parse((Reader)new FileReader(this.file));
        }
        catch (Exception e) {
            WitherCrumbsCore.logger.log(Level.ERROR, "Unable to parse the custom withers file! Skipping file loading.");
            WitherCrumbsCore.logger.log(Level.ERROR, "Parse Error: " + e.getMessage());
            return;
        }
        if (fileJson.isJsonNull()) {
            return;
        }
        for (Map.Entry witherUser : fileJson.getAsJsonObject().entrySet()) {
            ItemStack stack;
            String name;
            block9: {
                JsonObject info = ((JsonElement)witherUser.getValue()).getAsJsonObject();
                name = (String)witherUser.getKey();
                stack = new ItemStack((Item)WitherCrumbsItems.crumbStar, 1);
                if (info.has("DropItem")) {
                    String jsonRaw = info.get("DropItem").getAsJsonObject().toString();
                    try {
                        String jsonEdited = this.removedKeyQuotes(jsonRaw);
                        NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)jsonEdited);
                        if (!(nbtbase instanceof NBTTagCompound)) {
                            WitherCrumbsCore.logger.log(Level.ERROR, "Failed to convert the JSON to NBT for: " + jsonRaw);
                            continue;
                        }
                        NBTTagCompound nbtcomp = nbtbase;
                        stack = ItemStack.func_77949_a((NBTTagCompound)nbtcomp);
                        if (stack == null) {
                            WitherCrumbsCore.logger.log(Level.ERROR, "Failed to create an itemstack from the JSON of: " + jsonEdited + " and the NBT of: " + nbtbase.toString());
                        }
                        break block9;
                    }
                    catch (NBTException e1) {
                        WitherCrumbsCore.logger.log(Level.ERROR, e1.getMessage());
                    }
                    continue;
                }
            }
            WitherCrumbsCore.logger.log(Level.INFO, "Added custom WitherCrumb drop for " + name);
            CelebrityWitherRegistry.addCelebrityInfo(name, stack);
        }
    }

    public String removedKeyQuotes(String raw) {
        int secondQuote;
        StringBuilder sb = new StringBuilder(raw.toString());
        int index = 0;
        while ((index = sb.indexOf("\"", index)) != -1 && (secondQuote = sb.indexOf("\"", index + 1)) != -1) {
            if (sb.charAt(secondQuote + 1) == ':') {
                sb.deleteCharAt(index);
                sb.delete(secondQuote - 1, secondQuote);
                index = secondQuote;
                continue;
            }
            ++index;
        }
        return sb.toString();
    }
}

