/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.generator;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.gendeathrow.hatchery.block.TileUpgradable;
import com.gendeathrow.hatchery.block.generator.DigesterGeneratorBlock;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.init.ModFluids;
import com.gendeathrow.hatchery.inventory.InventoryStorage;
import com.gendeathrow.hatchery.item.upgrades.RFEfficiencyUpgrade;
import com.gendeathrow.hatchery.storage.EnergyStorageRF;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class DigesterGeneratorTileEntity
extends TileUpgradable
implements IInventory,
IEnergyProvider,
ITickable {
    public int time = 0;
    protected EnergyStorageRF energy = new EnergyStorageRF(200000);
    protected InventoryStorage inventory = new InventoryStorage(this, 2);
    private int rfPerTick = 20;
    private int baseRfPerTick = 20;
    boolean isGenerating;
    private FluidTank fertlizerTank = new FluidTank(new FluidStack(ModFluids.liquidfertilizer, 0), 5000){

        public boolean canDrain() {
            return false;
        }
    };
    int rfEnergyFuel = 15000;
    int fuelRF;
    boolean isActive = true;
    public float tankLevel;

    public DigesterGeneratorTileEntity() {
        super(2);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (!(oldState.func_177230_c() != ModBlocks.digesterGenerator && oldState.func_177230_c() != ModBlocks.digesterGeneratorOn || newSate.func_177230_c() != ModBlocks.digesterGenerator && newSate.func_177230_c() != ModBlocks.digesterGeneratorOn)) {
            return false;
        }
        return oldState != newSate;
    }

    protected boolean canGenerate() {
        return this.fuelRF > 0 ? true : this.getTank().getFluidAmount() >= 50;
    }

    public boolean isGenerating() {
        return this.fuelRF > 0;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.energy.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    public void func_73660_a() {
        boolean flag = this.isGenerating();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            IFluidHandler handler;
            this.updateRFPerTick();
            if (this.isActive && this.canGenerate() && this.energy.getEnergyStored() < this.energy.getMaxEnergyStored()) {
                if (this.fuelRF <= 0) {
                    this.fuelRF = this.rfEnergyFuel;
                    this.getTank().drainInternal(50, true);
                }
                this.energy.modifyEnergyStored(this.getRFPerTick());
                this.fuelRF -= this.getRFPerTick();
            }
            if (this.energy.getEnergyStored() > 0) {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                    if (tile == null || !(tile instanceof IEnergyReceiver)) continue;
                    int received = ((IEnergyReceiver)tile).receiveEnergy(facing.func_176734_d(), this.energy.getEnergyStored(), false);
                    this.extractEnergy(facing, received, false);
                }
            }
            if (this.inventory.func_70301_a(0) != null && this.inventory.func_70301_a(1) == null && this.fertlizerTank.getFluidAmount() < this.fertlizerTank.getCapacity() && (handler = FluidUtil.getFluidHandler((ItemStack)(stack = this.inventory.func_70301_a(0)))) != null && FluidUtil.tryFluidTransfer((IFluidHandler)this.fertlizerTank, (IFluidHandler)handler, (int)this.fertlizerTank.getCapacity(), (boolean)true) != null) {
                this.inventory.func_70299_a(1, stack);
                this.inventory.func_70299_a(0, null);
            }
            if (flag != this.isGenerating()) {
                DigesterGeneratorBlock.setState(this.isGenerating(), this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public FluidTank getTank() {
        return this.fertlizerTank;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.inventory.readFromNBT(nbt);
        this.energy.readFromNBT(nbt);
        this.fertlizerTank.readFromNBT(nbt);
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = this.inventory.writeToNBT(nbt);
        nbt = this.energy.writeToNBT(nbt);
        nbt = this.fertlizerTank.writeToNBT(nbt);
        return super.func_189515_b(nbt);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fertlizerTank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new InvWrapper((IInventory)this);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energy;
        }
        return (T)super.getCapability(capability, facing);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.func_70298_a(index, count);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.energy.getEnergyStored();
            }
            case 1: {
                return this.getTank().getFluidAmount();
            }
            case 2: {
                return this.rfPerTick;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.energy.setEnergyStored(value);
                break;
            }
            case 1: {
                this.tankLevel = value;
                break;
            }
            case 2: {
                this.rfPerTick = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public int getRFPerTick() {
        return this.rfPerTick;
    }

    protected void updateRFPerTick() {
        boolean rfupgrade = false;
        for (ItemStack upgrade : this.getUpgrades()) {
            if (upgrade == null || !(upgrade.func_77973_b() instanceof RFEfficiencyUpgrade)) continue;
            rfupgrade = true;
            int newTick = ((RFEfficiencyUpgrade)upgrade.func_77973_b()).getUpgradeTier(upgrade, "") * 20 + 20;
            if (newTick <= this.getRFPerTick()) continue;
            this.rfPerTick = newTick;
        }
        if (!rfupgrade) {
            this.rfPerTick = this.baseRfPerTick;
        }
    }
}

