/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import cofh.api.energy.IEnergyProvider;
import com.brandon3055.brandonscore.blocks.TileEnergyInventoryBase;
import com.brandon3055.brandonscore.network.wrappers.SyncableBool;
import com.brandon3055.brandonscore.network.wrappers.SyncableInt;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileGenerator
extends TileEnergyInventoryBase
implements IEnergyProvider,
ITickable {
    private int burnSpeed = 6;
    private int EPBT = 14;
    public final SyncableInt burnTime = new SyncableInt(1, false, true);
    public final SyncableInt burnTimeRemaining = new SyncableInt(0, false, true);
    public final SyncableBool active = new SyncableBool(false, true, false, true);

    public TileGenerator() {
        this.setInventorySize(1);
        this.registerSyncableObject((SyncableObject)this.burnTime, false);
        this.registerSyncableObject((SyncableObject)this.burnTimeRemaining, false);
        this.registerSyncableObject((SyncableObject)this.active, false);
        this.registerSyncableObject((SyncableObject)this.energyStored, false);
        this.setCapacityAndTransfer(100000, 0, 1000);
        this.setShouldRefreshOnBlockChange();
    }

    public void func_73660_a() {
        super.detectAndSendChanges();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = this.active.value = this.burnTimeRemaining.value > 0 && this.getEnergyStored() < this.getMaxEnergyStored();
        if (this.burnTimeRemaining.value > 0 && this.getEnergyStored() < this.getMaxEnergyStored()) {
            this.burnTimeRemaining.value -= this.burnSpeed;
            this.energyStorage.modifyEnergyStored(this.burnSpeed * this.EPBT);
        }
        if (this.burnTimeRemaining.value <= 0 && this.getEnergyStored() < this.getMaxEnergyStored()) {
            this.tryRefuel();
        }
        this.energyStorage.modifyEnergyStored(-this.sendEnergyToAll());
    }

    public void tryRefuel() {
        int itemBurnTime;
        if (this.burnTimeRemaining.value > 0 || this.getEnergyStored() >= this.getMaxEnergyStored()) {
            return;
        }
        ItemStack stack = this.func_70301_a(0);
        if (stack != null && stack.field_77994_a > 0 && (itemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)stack)) > 0) {
            --stack.field_77994_a;
            if (stack.field_77994_a == 0) {
                stack = stack.func_77973_b().getContainerItem(stack);
            }
            this.func_70299_a(0, stack);
            this.burnTime.value = itemBurnTime;
            this.burnTimeRemaining.value = itemBurnTime;
        }
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return super.extractEnergy(from, maxExtract, simulate);
    }

    public int getEnergyStored(EnumFacing from) {
        return super.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return super.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public void writeRetainedData(NBTTagCompound dataCompound) {
        super.writeRetainedData(dataCompound);
        this.burnTime.toNBT(dataCompound);
        this.burnTimeRemaining.toNBT(dataCompound);
        this.active.toNBT(dataCompound);
    }

    public void readRetainedData(NBTTagCompound dataCompound) {
        super.readRetainedData(dataCompound);
        this.burnTime.fromNBT(dataCompound);
        this.burnTimeRemaining.fromNBT(dataCompound);
        this.active.fromNBT(dataCompound);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
    }
}

