/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.material;

import net.darkhax.bookshelf.item.ItemBlockBasic;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.material.BlockWitherDust;
import net.darkhax.darkutils.features.material.ItemMaterial;
import net.darkhax.darkutils.libs.ModUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class FeatureMaterial
extends Feature {
    public static Item itemMaterial;
    public static Block blockWitherDust;
    private static boolean craftDustFromSkull;
    private static boolean craftDwindleCream;
    private static boolean craftUnstableEnderPearl;
    private static boolean skeletonDropDust;
    private static int dustDropWeight;
    private static boolean craftBlocks;
    private static boolean craftDarkSugar;
    private static boolean craftSoulSand;

    @Override
    public void onPreInit() {
        itemMaterial = new ItemMaterial();
        ModUtils.registerItem(itemMaterial, "material");
        blockWitherDust = new BlockWitherDust();
        ModUtils.registerBlock(blockWitherDust, (ItemBlock)new ItemBlockBasic(blockWitherDust, BlockWitherDust.types, false), "wither_block");
        OreDictionary.registerOre((String)"blockWither", (ItemStack)new ItemStack(blockWitherDust, 1, Short.MAX_VALUE));
    }

    @Override
    public void setupConfiguration(Configuration config) {
        craftDustFromSkull = config.getBoolean("Craft Wither Dust", this.configName, true, "Should the Wither Dust be craftable from Wither Skulls?");
        craftDwindleCream = config.getBoolean("Craft Dwindle Cream", this.configName, true, "Should Dwingle Cream be craftable?");
        craftUnstableEnderPearl = config.getBoolean("Craft Unstable Enderpearl", this.configName, true, "Should Unstable Enderpearls be craftable?");
        skeletonDropDust = config.getBoolean("WSkeleton Drop Dust", this.configName, true, "Should wither skeletons drop wither dust?");
        dustDropWeight = config.getInt("Dust Drop Weight", this.configName, 1, 0, 256, "The weighting for Wither Skeletons dropping Wither Dust");
        craftBlocks = config.getBoolean("Craft Blocks", this.configName, true, "Can wither dust blocks be crafted?");
        craftDarkSugar = config.getBoolean("Craft Dark Sugar", this.configName, true, "Should dark sugar be craftable?");
        craftSoulSand = config.getBoolean("Craft Soul Sand", this.configName, true, "Should soul sand be craftable with wither dust?");
    }

    @Override
    public void setupRecipes() {
        if (craftDustFromSkull) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(itemMaterial, 3, 0), (Object[])new Object[]{new ItemStack(Items.field_151144_bL, 1, 1)});
        }
        if (craftDwindleCream) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemMaterial, 1, 2), new Object[]{new ItemStack(itemMaterial, 1, 0), "slimeball"}));
        }
        if (craftUnstableEnderPearl) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemMaterial, 1, 1), new Object[]{new ItemStack(itemMaterial, 1, 0), "enderpearl"}));
        }
        if (craftDarkSugar) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(itemMaterial, 8, 3), (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), Items.field_151102_aT, Character.valueOf('y'), itemMaterial});
        }
        if (craftSoulSand) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150425_aM, 5, 0), new Object[]{"xyx", "yxy", "xyx", Character.valueOf('x'), "sand", Character.valueOf('y'), itemMaterial}));
        }
        if (craftBlocks) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(blockWitherDust, 1, 0), (Object[])new Object[]{"xx ", "xx ", Character.valueOf('x'), itemMaterial});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(itemMaterial, 4, 0), (Object[])new Object[]{new ItemStack(blockWitherDust, 3, Short.MAX_VALUE)});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(blockWitherDust, 4, 1), (Object[])new Object[]{"xx ", "xx ", Character.valueOf('x'), new ItemStack(blockWitherDust, 1, 0)});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(blockWitherDust, 4, 2), (Object[])new Object[]{"xx ", "xx ", Character.valueOf('x'), new ItemStack(blockWitherDust, 1, 1)});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(blockWitherDust, 4, 3), (Object[])new Object[]{"xx ", "xx ", Character.valueOf('x'), new ItemStack(blockWitherDust, 1, 2)});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(blockWitherDust, 4, 4), (Object[])new Object[]{"xx ", "xx ", Character.valueOf('x'), new ItemStack(blockWitherDust, 1, 3)});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(blockWitherDust, 4, 5), (Object[])new Object[]{"xx ", "xx ", Character.valueOf('x'), new ItemStack(blockWitherDust, 1, 4)});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(blockWitherDust, 4, 0), (Object[])new Object[]{"xx ", "xx ", Character.valueOf('x'), new ItemStack(blockWitherDust, 1, 5)});
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
        ModUtils.registerItemInvModel(itemMaterial, "material", ItemMaterial.varients);
        ModUtils.registerItemInvModel(Item.func_150898_a((Block)blockWitherDust), "wither", BlockWitherDust.types);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootPool pool1;
        LootTable table = event.getTable();
        if (skeletonDropDust && event.getName().equals((Object)LootTableList.field_186386_ak) && (pool1 = table.getPool("pool1")) != null) {
            pool1.addEntry((LootEntry)new LootEntryItem(itemMaterial, dustDropWeight, 0, new LootFunction[0], new LootCondition[0], "darkutils:wither_dust"));
        }
    }

    static {
        craftDustFromSkull = true;
        craftDwindleCream = true;
        craftUnstableEnderPearl = true;
        skeletonDropDust = true;
        dustDropWeight = 1;
        craftBlocks = true;
        craftDarkSugar = true;
        craftSoulSand = true;
    }
}

