/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.page.unit;

import engineers.workshop.client.container.slot.storage.SlotUnitStorage;
import engineers.workshop.client.page.Page;
import engineers.workshop.client.page.unit.Unit;
import engineers.workshop.common.items.Upgrade;
import engineers.workshop.common.table.TileTable;
import net.minecraft.item.ItemStack;

public class UnitStorage
extends Unit {
    private static final int START_X = 12;
    private static final int START_Y = 8;
    private static final int SLOT_SIZE = 18;
    private static final int GRID_WIDTH = 6;
    private static final int GRID_HEIGHT = 4;
    public static final int GRID_SIZE = 24;

    public UnitStorage(TileTable table, Page page, int id, int x, int y) {
        super(table, page, id, x, y);
    }

    @Override
    public int createSlots(int id) {
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 6; ++x) {
                this.addSlot(new SlotUnitStorage(this.table, this.page, id++, this.x + 12 + x * 18, this.y + 8 + y * 18, this));
            }
        }
        return id;
    }

    @Override
    protected ItemStack getProductionResult() {
        return null;
    }

    @Override
    protected int getOutputId() {
        return 0;
    }

    @Override
    protected void onProduction(ItemStack result) {
    }

    @Override
    public boolean isEnabled() {
        ItemStack item = this.table.getUpgradePage().getUpgradeMainItem(this.id);
        return item != null && Upgrade.ParentType.STORAGE.isValidParent(item);
    }
}

