/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.tileentity;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncEnum;
import sonar.core.utils.IGuiTile;
import sonar.flux.api.network.FluxCache;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxController;
import sonar.flux.client.GuiFluxController;
import sonar.flux.common.ContainerFlux;
import sonar.flux.common.tileentity.TileEntityFlux;

public class TileEntityController
extends TileEntityFlux
implements IGuiTile,
IFluxController {
    public SyncEnum<IFluxController.PriorityMode> sendMode = new SyncEnum((Enum[])IFluxController.PriorityMode.values(), 10);
    public SyncEnum<IFluxController.PriorityMode> receiveMode = new SyncEnum((Enum[])IFluxController.PriorityMode.values(), 11);
    public SyncEnum<IFluxController.TransmitterMode> transmitter = new SyncEnum((Enum[])IFluxController.TransmitterMode.values(), 12);
    public SyncEnum<IFluxController.TransferMode> transfer = new SyncEnum((Enum[])IFluxController.TransferMode.values(), 13);

    public TileEntityController() {
        super(IFlux.ConnectionType.CONTROLLER);
        this.syncList.addParts(new IDirtyPart[]{this.sendMode, this.receiveMode, this.transmitter, this.transfer});
        this.customName.setDefault((Object)"Flux Controller");
    }

    @Override
    public IFluxController.PriorityMode getSendMode() {
        return (IFluxController.PriorityMode)this.sendMode.getObject();
    }

    @Override
    public IFluxController.PriorityMode getReceiveMode() {
        return (IFluxController.PriorityMode)this.receiveMode.getObject();
    }

    @Override
    public IFluxController.TransmitterMode getTransmitterMode() {
        return (IFluxController.TransmitterMode)this.transmitter.getObject();
    }

    @Override
    public IFluxController.TransferMode getTransferMode() {
        return (IFluxController.TransferMode)this.transfer.getObject();
    }

    @Override
    public boolean canTransfer() {
        return true;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return false;
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerFlux(player, this, false);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiFluxController(player, this);
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        super.writePacket(buf, id);
        switch (id) {
            case 10: {
                this.sendMode.writeToBuf(buf);
                break;
            }
            case 11: {
                this.receiveMode.writeToBuf(buf);
                break;
            }
            case 12: {
                this.transfer.writeToBuf(buf);
                break;
            }
            case 13: {
                this.transmitter.writeToBuf(buf);
                break;
            }
            case 14: {
                this.customName.writeToBuf(buf);
            }
        }
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        super.readPacket(buf, id);
        switch (id) {
            case 10: {
                this.sendMode.readFromBuf(buf);
                this.network.markTypeDirty(FluxCache.controller);
                break;
            }
            case 11: {
                this.receiveMode.readFromBuf(buf);
                this.network.markTypeDirty(FluxCache.controller);
                break;
            }
            case 12: {
                this.transfer.readFromBuf(buf);
                break;
            }
            case 13: {
                this.transmitter.readFromBuf(buf);
                break;
            }
            case 14: {
                this.customName.readFromBuf(buf);
            }
        }
    }
}

