/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.common.entity.EntityFireItem;
import sonar.flux.network.FluxNetworkCache;
import sonar.flux.network.NetworkData;

public class FluxEvents {
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            FluxNetworkCache cache = FluxNetworks.getServerCache();
            ArrayList<IFluxNetwork> networks = cache.getAllNetworks();
            for (IFluxNetwork network : networks) {
                network.updateNetwork();
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getWorld().field_73011_w.getDimension() == 0) {
            NetworkData networkData = (NetworkData)event.getWorld().getPerWorldStorage().func_75742_a(NetworkData.class, "sonar.flux.networks.configurations");
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        MapStorage storage;
        NetworkData data;
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getWorld().field_73011_w.getDimension() == 0 && (data = (NetworkData)(storage = event.getWorld().getPerWorldStorage()).func_75742_a(NetworkData.class, "sonar.flux.networks.configurations")) == null && !FluxNetworks.getServerCache().getAllNetworks().isEmpty()) {
            storage.func_75745_a("sonar.flux.networks.configurations", (WorldSavedData)new NetworkData("sonar.flux.networks.configurations"));
        }
    }

    @SubscribeEvent
    public void onEntityAdded(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityItem && !(entity instanceof EntityFireItem)) {
            EntityItem entityItem = (EntityItem)entity;
            ItemStack stack = entityItem.func_92059_d();
            Item item = null;
            if (stack != null && (item = stack.func_77973_b()) != null && (item == Items.field_151137_ax || item == Items.field_151061_bv || item == Item.func_150898_a((Block)Blocks.field_150451_bX))) {
                EntityFireItem newEntity = new EntityFireItem(event.getWorld(), entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, stack);
                newEntity.field_70159_w = entityItem.field_70159_w;
                newEntity.field_70181_x = entityItem.field_70181_x;
                newEntity.field_70179_y = entityItem.field_70179_y;
                newEntity.func_174869_p();
                if (newEntity != null) {
                    event.getEntity().func_70106_y();
                    event.setCanceled(true);
                    event.getWorld().func_72838_d((Entity)newEntity);
                }
            }
        }
    }

    public static void logNewNetwork(IFluxNetwork network) {
        FluxNetworks.logger.info("[NEW NETWORK] '" + network.getNetworkName() + "' with ID '" + network.getNetworkID() + "' was created by " + network.getCachedPlayerName());
    }

    public static void logRemoveNetwork(IFluxNetwork network) {
        FluxNetworks.logger.info("[DELETE NETWORK] '" + network.getNetworkName() + "' with ID '" + network.getNetworkID() + "' was removed by " + network.getCachedPlayerName());
    }

    public static void logLoadedNetwork(IFluxNetwork network) {
        FluxNetworks.logger.info("[LOADED NETWORK] '" + network.getNetworkName() + "' with ID '" + network.getNetworkID() + "' with owner " + network.getCachedPlayerName());
    }
}

