/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads;

import java.io.File;
import java.util.Optional;
import net.blay09.mods.farmingforblockheads.CommandFarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.CommonProxy;
import net.blay09.mods.farmingforblockheads.ModConfig;
import net.blay09.mods.farmingforblockheads.ModRecipes;
import net.blay09.mods.farmingforblockheads.block.BlockMarket;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.compat.VanillaAddon;
import net.blay09.mods.farmingforblockheads.entity.EntityMerchant;
import net.blay09.mods.farmingforblockheads.network.GuiHandler;
import net.blay09.mods.farmingforblockheads.network.NetworkHandler;
import net.blay09.mods.farmingforblockheads.registry.AbstractRegistry;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.blay09.mods.farmingforblockheads.tile.TileMarket;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="farmingforblockheads", name="Farming for Blockheads", dependencies="after:mousetweaks[2.8,);after:forestry;after:agricraft", acceptedMinecraftVersions="[1.10.2]")
@Mod.EventBusSubscriber
public class FarmingForBlockheads {
    public static final String MOD_ID = "farmingforblockheads";
    @Mod.Instance(value="farmingforblockheads")
    public static FarmingForBlockheads instance;
    @SidedProxy(clientSide="net.blay09.mods.farmingforblockheads.client.ClientProxy", serverSide="net.blay09.mods.farmingforblockheads.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger logger;
    public static final CreativeTabs creativeTab;
    public static File configDir;
    private Configuration config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDir = new File(event.getModConfigurationDirectory(), "FarmingForBlockheads");
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new RuntimeException("Couldn't create Farming for Blockheads configuration directory");
        }
        this.config = new Configuration(new File(configDir, "FarmingForBlockheads.cfg"));
        this.config.load();
        ModConfig.preInit(this.config);
        GameRegistry.registerTileEntity(TileMarket.class, (String)"farmingforblockheads:market");
        proxy.preInit();
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkHandler.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        new VanillaAddon();
        this.buildSoftDependProxy("harvestcraft", "net.blay09.mods.farmingforblockheads.compat.HarvestcraftAddon");
        this.buildSoftDependProxy("forestry", "net.blay09.mods.farmingforblockheads.compat.ForestryAddon");
        this.buildSoftDependProxy("agricraft", "net.blay09.mods.farmingforblockheads.compat.AgriCraftAddon");
        this.buildSoftDependProxy("BiomesOPlenty", "net.blay09.mods.farmingforblockheads.compat.BiomesOPlentyAddon");
        this.buildSoftDependProxy("natura", "net.blay09.mods.farmingforblockheads.compat.NaturaAddon");
        ModRecipes.init();
        MarketRegistry.INSTANCE.load(configDir);
        EntityRegistry.registerModEntity(EntityMerchant.class, (String)"merchant", (int)0, (Object)this, (int)64, (int)3, (boolean)true);
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandFarmingForBlockheads());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Block[] blockArray = new Block[1];
        ModBlocks.market = new BlockMarket();
        blockArray[0] = ModBlocks.market;
        event.getRegistry().registerAll((IForgeRegistryEntry[])blockArray);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemBlock((Block)ModBlocks.market).setRegistryName(ModBlocks.market.getRegistryName())});
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (AbstractRegistry.registryErrors.size() > 0) {
            event.player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "There were errors loading the Farming for Blockheads registries:"));
            TextFormatting lastFormatting = TextFormatting.WHITE;
            for (String error : AbstractRegistry.registryErrors) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(lastFormatting + "* " + error));
                lastFormatting = lastFormatting == TextFormatting.GRAY ? TextFormatting.WHITE : TextFormatting.GRAY;
            }
        }
    }

    private Optional<?> buildSoftDependProxy(String modId, String className) {
        if (Loader.isModLoaded((String)modId)) {
            try {
                Class<?> clz = Class.forName(className, true, (ClassLoader)Loader.instance().getModClassLoader());
                return Optional.ofNullable(clz.newInstance());
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    static {
        logger = LogManager.getLogger();
        creativeTab = new CreativeTabs(MOD_ID){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)ModBlocks.market);
            }
        };
    }
}

