/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.VerticalAlignment;
import mcjty.lib.gui.widgets.AbstractWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class Label<P extends Label>
extends AbstractWidget<P> {
    private String text;
    private int color = StyleConfig.colorTextNormal;
    private int disabledColor = StyleConfig.colorTextDisabled;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.ALIGN_CENTER;
    private VerticalAlignment verticalAlignment = VerticalAlignment.ALIGN_CENTER;
    private boolean dynamic = false;
    private int txtDx = 0;
    private int txtDy = 0;
    private ResourceLocation image = null;
    private int u;
    private int v;
    private int iw;
    private int ih;

    public Label(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public ResourceLocation getImage() {
        return this.image;
    }

    public P setImage(ResourceLocation image, int u, int v, int iw, int ih) {
        this.image = image;
        this.u = u;
        this.v = v;
        this.iw = iw;
        this.ih = ih;
        return (P)this;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public P setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return (P)this;
    }

    @Override
    public int getDesiredWidth() {
        int w = super.getDesiredWidth();
        if (this.dynamic) {
            return w;
        }
        if (w == -1) {
            w = this.mc.field_71466_p.func_78256_a(this.text) + 6;
        }
        return w;
    }

    @Override
    public int getDesiredHeight() {
        int h = super.getDesiredHeight();
        if (this.dynamic) {
            return h;
        }
        if (h == -1) {
            h = this.mc.field_71466_p.field_78288_b + 2;
        }
        return h;
    }

    public String getText() {
        return this.text;
    }

    public P setText(String text) {
        this.text = text;
        return (P)this;
    }

    public P setTextOffset(int ox, int oy) {
        this.txtDx = ox;
        this.txtDy = oy;
        return (P)this;
    }

    public int getColor() {
        return this.color;
    }

    public P setColor(int color) {
        this.color = color;
        return (P)this;
    }

    public int getDisabledColor() {
        return this.disabledColor;
    }

    public P setDisabledColor(int disabledColor) {
        this.disabledColor = disabledColor;
        return (P)this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public P setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return (P)this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public P setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return (P)this;
    }

    @Override
    public void draw(Window window, int x, int y) {
        this.drawOffset(window, x, y, 0, 0);
    }

    public void drawOffset(Window window, int x, int y, int offsetx, int offsety) {
        if (!this.visible) {
            return;
        }
        super.draw(window, x, y);
        int dx = this.calculateHorizontalOffset() + offsetx + this.txtDx;
        int dy = this.calculateVerticalOffset() + offsety + this.txtDy;
        if (this.image != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(this.image);
            int xx = x + this.bounds.x + (this.bounds.width - this.iw) / 2;
            int yy = y + this.bounds.y + (this.bounds.height - this.ih) / 2;
            this.gui.func_73729_b(xx, yy, this.u, this.v, this.iw, this.ih);
        }
        int col = this.color;
        if (!this.isEnabled()) {
            col = this.disabledColor;
        }
        if (this.text == null) {
            this.mc.field_71466_p.func_78276_b("", x + dx + this.bounds.x, y + dy + this.bounds.y, col);
        } else {
            this.mc.field_71466_p.func_78276_b(this.mc.field_71466_p.func_78269_a(this.text, this.bounds.width), x + dx + this.bounds.x, y + dy + this.bounds.y, col);
        }
    }

    private int calculateVerticalOffset() {
        if (this.verticalAlignment != VerticalAlignment.ALIGN_TOP) {
            int h = this.mc.field_71466_p.field_78288_b;
            if (this.verticalAlignment == VerticalAlignment.ALIGN_BOTTOM) {
                return this.bounds.height - h;
            }
            return (this.bounds.height - h) / 2;
        }
        return 0;
    }

    private int calculateHorizontalOffset() {
        if (this.horizontalAlignment != HorizontalAlignment.ALIGH_LEFT) {
            int w = this.mc.field_71466_p.func_78256_a(this.text);
            if (this.horizontalAlignment == HorizontalAlignment.ALIGN_RIGHT) {
                return this.bounds.width - w;
            }
            return (this.bounds.width - w) / 2;
        }
        return 0;
    }
}

