/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.brackets.util;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import modtweaker.brackets.util.IMaterial;
import modtweaker.brackets.util.IMaterialDefinition;
import modtweaker.brackets.util.MCMaterialDefinition;
import modtweaker.mods.tconstruct.actions.SetAttackAction;
import modtweaker.mods.tconstruct.actions.SetDurabilityAction;
import modtweaker.mods.tconstruct.actions.SetHarvestLevelAction;
import modtweaker.mods.tconstruct.actions.SetMiningSpeedAction;
import modtweaker.mods.tconstruct.actions.SetModifierAction;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class MCMaterial
implements IMaterial {
    private final Material material;

    public MCMaterial(Material material) {
        this.material = material;
        System.out.println("added: " + material.getIdentifier());
    }

    @Override
    public String getName() {
        return this.material.getIdentifier();
    }

    @Override
    public boolean matches(IMaterial var1) {
        return var1.getName().equals(this.getName());
    }

    @Override
    public Object getInternal() {
        return this.material;
    }

    @Override
    public IMaterialDefinition getDefinition() {
        return new MCMaterialDefinition(this.material);
    }

    @Override
    public void setDurabilityHead(int durability) {
        MineTweakerAPI.apply((IUndoableAction)new SetDurabilityAction(this, "head", durability));
    }

    @Override
    public int getDurabilityHead() {
        return ((HeadMaterialStats)this.material.getStats((String)"head")).durability;
    }

    @Override
    public void setMiningSpeedHead(float miningSpeed) {
        MineTweakerAPI.apply((IUndoableAction)new SetMiningSpeedAction(this, "head", miningSpeed));
    }

    @Override
    public float getMiningSpeedHead() {
        return ((HeadMaterialStats)this.material.getStats((String)"head")).miningspeed;
    }

    @Override
    public void setAttackHead(float attack) {
        MineTweakerAPI.apply((IUndoableAction)new SetAttackAction(this, "head", attack));
    }

    @Override
    public float getAttackHead() {
        return ((HeadMaterialStats)this.material.getStats((String)"head")).attack;
    }

    @Override
    public void setHarvestLevelHead(int level) {
        MineTweakerAPI.apply((IUndoableAction)new SetHarvestLevelAction(this, "head", level));
    }

    @Override
    public int getHarvestLevelHead() {
        return ((HeadMaterialStats)this.material.getStats((String)"head")).harvestLevel;
    }

    @Override
    public void setDurabilityHandle(int durability) {
        MineTweakerAPI.apply((IUndoableAction)new SetDurabilityAction(this, "handle", durability));
    }

    @Override
    public int getDurabilityHandle() {
        return ((HandleMaterialStats)this.material.getStats((String)"handle")).durability;
    }

    @Override
    public void setModifierHandle(float modifier) {
        MineTweakerAPI.apply((IUndoableAction)new SetModifierAction(this, "handle", modifier));
    }

    @Override
    public float getModifierHandle() {
        return ((HandleMaterialStats)this.material.getStats((String)"handle")).modifier;
    }

    @Override
    public void setDurabilityExtra(int durability) {
        MineTweakerAPI.apply((IUndoableAction)new SetDurabilityAction(this, "extra", durability));
    }

    @Override
    public int getDurabilityExtra() {
        return ((HandleMaterialStats)this.material.getStats((String)"extra")).durability;
    }
}

