/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util.helper;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;

public class InventoryRenderHelperV2 {
    private final String domain;

    public InventoryRenderHelperV2(String domain) {
        this.domain = domain.endsWith(":") ? domain.replace(":", "") : domain;
    }

    public void registerMesher(Item item, ItemMeshDefinition meshDefinition) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshDefinition);
    }

    public void registerRender(Item item, int meta, String name, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(this.domain, "item/" + name), "type=" + variant));
    }

    public void registerRender(Item item, int meta, String variant) {
        this.registerRender(item, meta, item.getRegistryName().func_110623_a(), variant);
    }

    public void registerRender(Item item, String name, String variant) {
        this.registerRender(item, 0, name, variant);
    }

    public void registerRender(Item item, String variant) {
        this.registerRender(item, item.getRegistryName().func_110623_a(), variant);
    }

    public void registerRender(Block block, int meta, String name, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(this.domain, name), variant));
    }

    public void registerRender(Block block, int meta, String variant) {
        this.registerRender(block, meta, block.getRegistryName().func_110623_a(), variant);
    }

    public void registerRender(Block block, String name, String variant) {
        this.registerRender(block, 0, name, variant);
    }

    public void registerRender(Block block, String variant) {
        this.registerRender(block, block.getRegistryName().func_110623_a(), variant);
    }
}

