/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.api.soul.DemonWillHolder;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.IDemonWillConduit;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.registry.ModBlocks;
import WayofTime.bloodmagic.tile.TileDemonCrystal;
import WayofTime.bloodmagic.tile.base.TileTicking;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileDemonCrystallizer
extends TileTicking
implements IDemonWillConduit {
    public DemonWillHolder holder = new DemonWillHolder();
    public static final int maxWill = 100;
    public static final double drainRate = 1.0;
    public static final double willToFormCrystal = 99.0;
    public static final double totalFormationTime = 1000.0;
    public double internalCounter = 0.0;

    @Override
    public void onUpdate() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        BlockPos offsetPos = this.field_174879_c.func_177972_a(EnumFacing.UP);
        if (this.func_145831_w().func_175623_d(offsetPos)) {
            EnumDemonWillType highestType = WorldDemonWillHandler.getHighestDemonWillType(this.func_145831_w(), this.field_174879_c);
            double amount = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, highestType);
            if (amount >= 99.0) {
                this.internalCounter += this.getCrystalFormationRate(amount);
                if (this.internalCounter >= 1000.0 && WorldDemonWillHandler.drainWill(this.func_145831_w(), this.func_174877_v(), highestType, 99.0, false) >= 99.0 && (highestType == EnumDemonWillType.DEFAULT && this.formRandomSpecialCrystal(offsetPos) || this.formCrystal(highestType, offsetPos))) {
                    WorldDemonWillHandler.drainWill(this.func_145831_w(), this.func_174877_v(), highestType, 99.0, true);
                    this.internalCounter = 0.0;
                }
            }
        }
    }

    public boolean formCrystal(EnumDemonWillType type, BlockPos position) {
        this.func_145831_w().func_175656_a(position, ModBlocks.DEMON_CRYSTAL.func_176203_a(type.ordinal()));
        TileEntity tile = this.func_145831_w().func_175625_s(position);
        if (tile instanceof TileDemonCrystal) {
            ((TileDemonCrystal)tile).setPlacement(EnumFacing.UP);
            return true;
        }
        return false;
    }

    public boolean formRandomSpecialCrystal(BlockPos position) {
        if (this.func_145831_w().field_73012_v.nextDouble() > 0.1) {
            return this.formCrystal(EnumDemonWillType.DEFAULT, position);
        }
        EnumDemonWillType crystalType = EnumDemonWillType.values()[this.func_145831_w().field_73012_v.nextInt(EnumDemonWillType.values().length - 1) + 1];
        return this.formCrystal(crystalType, position);
    }

    public double getCrystalFormationRate(double currentWill) {
        return 1.0;
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        this.holder.readFromNBT(tag, "Will");
        this.internalCounter = tag.func_74769_h("internalCounter");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        this.holder.writeToNBT(tag, "Will");
        tag.func_74780_a("internalCounter", this.internalCounter);
        return tag;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public double fillDemonWill(EnumDemonWillType type, double amount, boolean doFill) {
        if (amount <= 0.0) {
            return 0.0;
        }
        if (!this.canFill(type)) {
            return 0.0;
        }
        if (!doFill) {
            return Math.min(100.0 - this.holder.getWill(type), amount);
        }
        return this.holder.addWill(type, amount, 100.0);
    }

    @Override
    public double drainDemonWill(EnumDemonWillType type, double amount, boolean doDrain) {
        double drained = amount;
        double current = this.holder.getWill(type);
        if (current < drained) {
            drained = current;
        }
        if (doDrain) {
            return this.holder.drainWill(type, amount);
        }
        return drained;
    }

    @Override
    public boolean canFill(EnumDemonWillType type) {
        return true;
    }

    @Override
    public boolean canDrain(EnumDemonWillType type) {
        return true;
    }

    @Override
    public double getCurrentWill(EnumDemonWillType type) {
        return this.holder.getWill(type);
    }
}

