/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.registry;

import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.ItemStackWrapper;
import WayofTime.bloodmagic.api.altar.EnumAltarTier;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class AltarRecipeRegistry {
    private static BiMap<List<ItemStackWrapper>, AltarRecipe> recipes = HashBiMap.create();

    public static void registerRecipe(AltarRecipe altarRecipe) {
        if (!recipes.containsValue((Object)altarRecipe) && altarRecipe.getInput().size() > 0) {
            recipes.put(altarRecipe.getInput(), (Object)altarRecipe);
        } else {
            BloodMagicAPI.getLogger().error("Error adding altar recipe for input [{}].", altarRecipe.toString());
        }
    }

    public static void registerFillRecipe(ItemStack orbStack, EnumAltarTier tier, int maxForOrb, int consumeRate, int drainRate) {
        AltarRecipeRegistry.registerRecipe(new AltarRecipe(orbStack, orbStack, tier, maxForOrb, consumeRate, drainRate, true));
    }

    public static void removeRecipe(AltarRecipe altarRecipe) {
        recipes.remove(altarRecipe.getInput());
    }

    public static AltarRecipe getRecipeForInput(List<ItemStack> input) {
        List<ItemStackWrapper> wrapperList = ItemStackWrapper.toWrapperList(input);
        if (recipes.keySet().contains(wrapperList)) {
            return (AltarRecipe)recipes.get(wrapperList);
        }
        return null;
    }

    public static AltarRecipe getRecipeForInput(ItemStack input) {
        for (AltarRecipe recipe : recipes.values()) {
            if (!recipe.doesRequiredItemMatch(input, recipe.getMinTier())) continue;
            return recipe;
        }
        return null;
    }

    public static AltarRecipe getRecipeForInput(String input) {
        return AltarRecipeRegistry.getRecipeForInput(OreDictionary.getOres((String)input));
    }

    public static BiMap<List<ItemStackWrapper>, AltarRecipe> getRecipes() {
        return HashBiMap.create(recipes);
    }

    public static class AltarRecipe {
        private final List<ItemStackWrapper> input;
        private final ItemStack output;
        private final EnumAltarTier minTier;
        private final int syphon;
        private final int consumeRate;
        private final int drainRate;
        private final boolean fillable;

        public AltarRecipe(List<ItemStack> input, ItemStack output, EnumAltarTier minTier, int syphon, int consumeRate, int drainRate, boolean fillable) {
            this.input = ItemStackWrapper.toWrapperList(input);
            this.output = output;
            this.minTier = minTier;
            this.syphon = syphon < 0 ? -syphon : syphon;
            this.consumeRate = consumeRate < 0 ? -consumeRate : consumeRate;
            this.drainRate = drainRate < 0 ? -drainRate : drainRate;
            this.fillable = fillable;
        }

        public AltarRecipe(List<ItemStack> input, ItemStack output, EnumAltarTier minTier, int syphon, int consumeRate, int drainRate) {
            this(input, output, minTier, syphon, consumeRate, drainRate, false);
        }

        public AltarRecipe(ItemStack input, ItemStack output, EnumAltarTier minTier, int syphon, int consumeRate, int drainRate, boolean fillable) {
            this(Collections.singletonList(input), output, minTier, syphon, consumeRate, drainRate, fillable);
        }

        public AltarRecipe(ItemStack input, ItemStack output, EnumAltarTier minTier, int syphon, int consumeRate, int drainRate) {
            this(Collections.singletonList(input), output, minTier, syphon, consumeRate, drainRate, false);
        }

        public AltarRecipe(String inputEntry, ItemStack output, EnumAltarTier minTier, int syphon, int consumeRate, int drainRate, boolean fillable) {
            this(OreDictionary.doesOreNameExist((String)inputEntry) && OreDictionary.getOres((String)inputEntry).size() > 0 ? OreDictionary.getOres((String)inputEntry) : Collections.emptyList(), output, minTier, syphon, consumeRate, drainRate, fillable);
        }

        public AltarRecipe(String inputEntry, ItemStack output, EnumAltarTier minTier, int syphon, int consumeRate, int drainRate) {
            this(OreDictionary.doesOreNameExist((String)inputEntry) && OreDictionary.getOres((String)inputEntry).size() > 0 ? OreDictionary.getOres((String)inputEntry) : Collections.emptyList(), output, minTier, syphon, consumeRate, drainRate, false);
        }

        public boolean doesRequiredItemMatch(ItemStack comparedStack, EnumAltarTier tierCheck) {
            if (comparedStack == null || this.input == null) {
                return false;
            }
            if (tierCheck.ordinal() < this.minTier.ordinal()) {
                return false;
            }
            for (ItemStackWrapper stack : this.input) {
                if (comparedStack.func_77969_a(stack.toStack())) {
                    return true;
                }
                if (comparedStack.func_77973_b() != stack.item || stack.meta != Short.MAX_VALUE) continue;
                return true;
            }
            return false;
        }

        public List<ItemStackWrapper> getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public EnumAltarTier getMinTier() {
            return this.minTier;
        }

        public int getSyphon() {
            return this.syphon;
        }

        public int getConsumeRate() {
            return this.consumeRate;
        }

        public int getDrainRate() {
            return this.drainRate;
        }

        public boolean isFillable() {
            return this.fillable;
        }

        public String toString() {
            return "AltarRecipeRegistry.AltarRecipe(input=" + this.getInput() + ", output=" + this.getOutput() + ", minTier=" + (Object)((Object)this.getMinTier()) + ", syphon=" + this.getSyphon() + ", consumeRate=" + this.getConsumeRate() + ", drainRate=" + this.getDrainRate() + ", fillable=" + this.isFillable() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AltarRecipe)) {
                return false;
            }
            AltarRecipe other = (AltarRecipe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ItemStackWrapper> this$input = this.getInput();
            List<ItemStackWrapper> other$input = other.getInput();
            if (this$input == null ? other$input != null : !((Object)this$input).equals(other$input)) {
                return false;
            }
            ItemStack this$output = this.getOutput();
            ItemStack other$output = other.getOutput();
            if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
                return false;
            }
            EnumAltarTier this$minTier = this.getMinTier();
            EnumAltarTier other$minTier = other.getMinTier();
            if (this$minTier == null ? other$minTier != null : !((Object)((Object)this$minTier)).equals((Object)other$minTier)) {
                return false;
            }
            if (this.getSyphon() != other.getSyphon()) {
                return false;
            }
            if (this.getConsumeRate() != other.getConsumeRate()) {
                return false;
            }
            if (this.getDrainRate() != other.getDrainRate()) {
                return false;
            }
            return this.isFillable() == other.isFillable();
        }

        protected boolean canEqual(Object other) {
            return other instanceof AltarRecipe;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ItemStackWrapper> $input = this.getInput();
            result = result * 59 + ($input == null ? 43 : ((Object)$input).hashCode());
            ItemStack $output = this.getOutput();
            result = result * 59 + ($output == null ? 43 : $output.hashCode());
            EnumAltarTier $minTier = this.getMinTier();
            result = result * 59 + ($minTier == null ? 43 : ((Object)((Object)$minTier)).hashCode());
            result = result * 59 + this.getSyphon();
            result = result * 59 + this.getConsumeRate();
            result = result * 59 + this.getDrainRate();
            result = result * 59 + (this.isFillable() ? 79 : 97);
            return result;
        }
    }
}

