/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api;

import WayofTime.bloodmagic.api.BlockStack;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackWrapper {
    public final Item item;
    public final int stackSize;
    public final int meta;
    public NBTTagCompound nbtTag;

    public ItemStackWrapper(Item item, int stackSize) {
        this(item, stackSize, 0);
    }

    public ItemStackWrapper(Item item) {
        this(item, 1, 0);
    }

    public ItemStackWrapper(Block block, int stackSize, int meta) {
        this(Item.func_150898_a((Block)block), stackSize, meta);
    }

    public ItemStackWrapper(Block block, int stackSize) {
        this(block, stackSize, 0);
    }

    public ItemStackWrapper(Block block) {
        this(block, 1, 0);
    }

    public ItemStackWrapper(BlockStack blockStack) {
        this(blockStack.getBlock(), 1, blockStack.getMeta());
    }

    @Nullable
    public static ItemStackWrapper getHolder(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStackWrapper wrapper = new ItemStackWrapper(stack.func_77973_b(), stack.field_77994_a, stack.func_77952_i());
        wrapper.setNbtTag(stack.func_77978_p());
        return wrapper;
    }

    public ItemStack toStack() {
        return new ItemStack(this.item, this.stackSize, this.meta);
    }

    public String getDisplayName() {
        return this.toStack().func_82833_r();
    }

    public String toString() {
        return this.stackSize + "x" + this.item.func_77658_a() + "@" + this.meta;
    }

    public ItemStack toStack(int count) {
        ItemStack result = new ItemStack(this.item, count, this.meta);
        result.func_77982_d(this.nbtTag);
        return result;
    }

    public static List<ItemStackWrapper> toWrapperList(List<ItemStack> itemStackList) {
        ArrayList<ItemStackWrapper> wrapperList = new ArrayList<ItemStackWrapper>();
        for (ItemStack stack : itemStackList) {
            wrapperList.add(ItemStackWrapper.getHolder(stack));
        }
        return wrapperList;
    }

    public static List<ItemStack> toStackList(List<ItemStackWrapper> wrapperList) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (ItemStackWrapper wrapper : wrapperList) {
            stackList.add(wrapper.toStack());
        }
        return stackList;
    }

    @ConstructorProperties(value={"item", "stackSize", "meta"})
    public ItemStackWrapper(Item item, int stackSize, int meta) {
        this.item = item;
        this.stackSize = stackSize;
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemStackWrapper)) {
            return false;
        }
        ItemStackWrapper other = (ItemStackWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Item this$item = this.item;
        Item other$item = other.item;
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        if (this.stackSize != other.stackSize) {
            return false;
        }
        if (this.meta != other.meta) {
            return false;
        }
        NBTTagCompound this$nbtTag = this.nbtTag;
        NBTTagCompound other$nbtTag = other.nbtTag;
        return !(this$nbtTag == null ? other$nbtTag != null : !this$nbtTag.equals(other$nbtTag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemStackWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Item $item = this.item;
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        result = result * 59 + this.stackSize;
        result = result * 59 + this.meta;
        NBTTagCompound $nbtTag = this.nbtTag;
        result = result * 59 + ($nbtTag == null ? 43 : $nbtTag.hashCode());
        return result;
    }

    public void setNbtTag(NBTTagCompound nbtTag) {
        this.nbtTag = nbtTag;
    }
}

