/*
 * Decompiled with CFR 0.152.
 */
package eladkay.scanner.terrain;

import eladkay.scanner.ScannerMod;
import eladkay.scanner.misc.BaseTE;
import eladkay.scanner.terrain.TileEntityTerrainScanner;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityScannerQueue
extends BaseTE
implements ITickable,
Iterable<BlockPos> {
    public Queue<BlockPos> queue = new ArrayDeque<BlockPos>();
    transient TileEntityTerrainScanner scanner;
    public boolean flag;
    static final int CAPACITY = 5;

    @Nullable
    public static TileEntityScannerQueue getNearbyQueue(World world, TileEntityTerrainScanner scanner) {
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity te = world.func_175625_s(scanner.func_174877_v().func_177972_a(facing));
            if (!(te instanceof TileEntityScannerQueue)) continue;
            return (TileEntityScannerQueue)te;
        }
        return null;
    }

    @Nullable
    private static <T extends TileEntity> T getNearbyQueue0(World world, TileEntity scanner, Class<T> block) {
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity te = world.func_175625_s(scanner.func_174877_v().func_177972_a(facing));
            if (te == null || !block.isAssignableFrom(te.getClass())) continue;
            return (T)te;
        }
        return null;
    }

    @Nullable
    public BlockPos pop() {
        return this.queue.poll();
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return this.queue.iterator();
    }

    public int size() {
        return this.queue.size();
    }

    @Nullable
    public BlockPos get(int index) {
        int i = 0;
        for (BlockPos pos : this) {
            if (index != i++) continue;
            return pos;
        }
        return null;
    }

    public void remove(BlockPos pos) {
        this.queue.remove(pos);
    }

    public void push(BlockPos pos) {
        if (this.queue.size() >= 5) {
            return;
        }
        this.queue.add(pos);
    }

    @Nullable
    public BlockPos peek() {
        return this.queue.peek();
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList list = new NBTTagList();
        for (BlockPos pos : this.queue) {
            list.func_74742_a((NBTBase)new NBTTagLong(pos.func_177986_g()));
        }
        nbt.func_74782_a("queue", (NBTBase)list);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("queue", 4);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.queue.add(BlockPos.func_177969_a((long)((NBTTagLong)list.func_179238_g(i)).func_150291_c()));
        }
    }

    public TileEntityScannerQueue() {
        super(0);
    }

    public void func_73660_a() {
        this.scanner = TileEntityScannerQueue.getNearbyQueue0(this.func_145831_w(), this, TileEntityTerrainScanner.class);
        if (this.scanner != null) {
            this.flag = false;
            for (EnumFacing facing : EnumFacing.values()) {
                this.flag |= this.func_145831_w().func_180495_p(this.scanner.func_174877_v().func_177972_a(facing)).func_177230_c() == ScannerMod.biomeScannerUltimate;
            }
        }
    }
}

