/*
 * Decompiled with CFR 0.152.
 */
package eladkay.scanner.terrain;

import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.MouseButton;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiChunkSelectorBase;
import com.feed_the_beast.ftbl.lib.gui.misc.ThreadReloadChunkSelector;
import eladkay.scanner.Config;
import eladkay.scanner.misc.MessageUpdateEnergyServer;
import eladkay.scanner.misc.NetworkHelper;
import eladkay.scanner.terrain.MessageUpdateScanner;
import eladkay.scanner.terrain.TileEntityTerrainScanner;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiBuildRemotely
extends GuiChunkSelectorBase {
    private static final Color4I COL_GREEN = new Color4I(false, 0x6600FF00);
    public static GuiBuildRemotely instance;
    private final Button buttonRefresh;
    private final Button buttonClose;
    private final TileEntityTerrainScanner scanner;

    public GuiBuildRemotely(TileEntityTerrainScanner scanner) {
        this.scanner = scanner;
        this.buttonClose = new Button(0, 0, 16, 16, GuiLang.BUTTON_CLOSE.translate()){

            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                GuiBuildRemotely.this.closeGui();
            }
        };
        this.buttonRefresh = new Button(0, 16, 16, 16, GuiLang.BUTTON_REFRESH.translate()){

            public void onClicked(GuiBase gui, IMouseButton button) {
                ThreadReloadChunkSelector.reloadArea((World)GuiBuildRemotely.this.mc.field_71441_e, (int)GuiBuildRemotely.this.startX, (int)GuiBuildRemotely.this.startZ);
            }
        };
    }

    public void onInit() {
        this.buttonRefresh.onClicked((GuiBase)this, (IMouseButton)MouseButton.LEFT);
    }

    public void onChunksSelected(Collection<ChunkPos> chunks) {
        ChunkPos pos = chunks.iterator().next();
        NetworkHelper.instance.sendToServer((IMessage)new MessageUpdateEnergyServer(this.scanner.func_174877_v().func_177958_n(), this.scanner.func_174877_v().func_177956_o(), this.scanner.func_174877_v().func_177952_p()));
        if (this.scanner.getEnergyStored(null) < Config.remoteBuildCost) {
            return;
        }
        this.scanner.container().extractEnergy(Config.remoteBuildCost, false);
        this.scanner.on = false;
        this.scanner.posStart = new BlockPos(pos.field_77276_a << 4, 0, pos.field_77275_b << 4);
        this.scanner.current = new BlockPos.MutableBlockPos(0, -1, 0);
        this.scanner.func_70296_d();
        NetworkHelper.instance.sendToServer((IMessage)new MessageUpdateScanner(this.scanner));
    }

    public void addCornerButtons(Panel panel) {
        panel.add((Widget)this.buttonClose);
        panel.add((Widget)this.buttonRefresh);
    }

    public void addButtonText(GuiChunkSelectorBase.MapButton button, List<String> list) {
        list.add("Click to scan!");
        list.add("Power cost: " + Config.remoteBuildCost);
        list.add(button.chunkPos.toString());
        NetworkHelper.instance.sendToServer((IMessage)new MessageUpdateEnergyServer(this.scanner.func_174877_v().func_177958_n(), this.scanner.func_174877_v().func_177956_o(), this.scanner.func_174877_v().func_177952_p()));
        if (this.scanner.posStart != null && this.scanner.posStart.func_177958_n() >> 4 == button.chunkPos.field_77276_a && this.scanner.posStart.func_177952_p() >> 4 == button.chunkPos.field_77275_b) {
            list.add("Already building!");
        } else if (this.scanner.getEnergyStored(null) < Config.remoteBuildCost) {
            list.add("Insufficient power!");
        }
    }
}

