/*
 * Decompiled with CFR 0.152.
 */
package eladkay.scanner.biome;

import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.MouseButton;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiChunkSelectorBase;
import com.feed_the_beast.ftbl.lib.gui.misc.ThreadReloadChunkSelector;
import eladkay.scanner.Config;
import eladkay.scanner.biome.MessageUpdateMap;
import eladkay.scanner.biome.TileEntityBiomeScanner;
import eladkay.scanner.misc.MessageUpdateEnergyServer;
import eladkay.scanner.misc.NetworkHelper;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiBiomeScanner
extends GuiChunkSelectorBase {
    public static GuiBiomeScanner instance;
    private final Button buttonRefresh;
    private final Button buttonClose;
    private final TileEntityBiomeScanner scanner;

    public GuiBiomeScanner(TileEntityBiomeScanner scanner) {
        this.scanner = scanner;
        this.buttonClose = new Button(0, 0, 16, 16, GuiLang.BUTTON_CLOSE.translate()){

            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                GuiBiomeScanner.this.closeGui();
            }
        };
        this.buttonRefresh = new Button(0, 16, 16, 16, GuiLang.BUTTON_REFRESH.translate()){

            public void onClicked(GuiBase gui, IMouseButton button) {
                ThreadReloadChunkSelector.reloadArea((World)GuiBiomeScanner.this.mc.field_71441_e, (int)GuiBiomeScanner.this.startX, (int)GuiBiomeScanner.this.startZ);
            }
        };
    }

    public void onInit() {
        this.buttonRefresh.onClicked((GuiBase)this, (IMouseButton)MouseButton.LEFT);
    }

    public void onChunksSelected(Collection<ChunkPos> chunks) {
        ChunkPos pos = chunks.iterator().next();
        int distance = this.scanner.getDist(pos);
        NetworkHelper.instance.sendToServer((IMessage)new MessageUpdateEnergyServer(this.scanner.func_174877_v().func_177958_n(), this.scanner.func_174877_v().func_177956_o(), this.scanner.func_174877_v().func_177952_p()));
        if (this.scanner.getMapping(pos.field_77276_a, pos.field_77275_b) != null || this.scanner.getEnergyStored(null) < Config.minEnergyPerChunkBiomeScanner * Config.increase * distance) {
            return;
        }
        if (distance > 1 << this.scanner.type + 1) {
            return;
        }
        this.scanner.container().extractEnergy(Config.minEnergyPerChunkBiomeScanner * Config.increase * distance, false);
        this.scanner.mapping.put(new ChunkPos(pos.field_77276_a, pos.field_77275_b), this.mc.field_71441_e.func_180494_b(new BlockPos(pos.field_77276_a << 4, 64, pos.field_77275_b << 4)).func_185359_l());
        this.scanner.func_70296_d();
        NetworkHelper.instance.sendToServer((IMessage)new MessageUpdateMap(this.scanner, pos.field_77276_a, pos.field_77275_b));
    }

    public void addCornerButtons(Panel panel) {
        panel.add((Widget)this.buttonClose);
        panel.add((Widget)this.buttonRefresh);
    }

    public void addButtonText(GuiChunkSelectorBase.MapButton button, List<String> list) {
        int distance = this.scanner.getDist(button.chunkPos);
        if (this.scanner.getMapping(button.chunkPos.field_77276_a, button.chunkPos.field_77275_b) != null) {
            list.add(this.scanner.getMapping(button.chunkPos.field_77276_a, button.chunkPos.field_77275_b));
            list.add("(" + button.chunkPos.field_77276_a + ", " + button.chunkPos.field_77275_b + ")");
        } else {
            list.add("???");
            list.add("Click to scan!");
            list.add("Power cost: " + Config.minEnergyPerChunkBiomeScanner * Config.increase * distance);
            list.add("Distance (chunks): " + distance);
            if (this.scanner.type == 0 && distance > 2) {
                list.add("Basic Biome Scanner cannot scan chunks more than 2 chunks away!");
            } else if (this.scanner.type == 1 && distance > 4) {
                list.add("Advanced Biome Scanner cannot scan chunks more than 4 chunks away!");
            } else if (this.scanner.type == 2 && distance > 8) {
                list.add("Elite Biome Scanner cannot scan chunks more than 8 chunks away!");
            }
        }
        if (GuiScreen.func_146271_m()) {
            list.add(button.chunkPos.toString());
        }
    }
}

