/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.compatibility;

import exnihiloadscensio.blocks.BlockBarrel;
import exnihiloadscensio.blocks.BlockCrucible;
import exnihiloadscensio.blocks.BlockInfestedLeaves;
import exnihiloadscensio.blocks.BlockSieve;
import exnihiloadscensio.registries.CrucibleRegistry;
import exnihiloadscensio.tiles.TileBarrel;
import exnihiloadscensio.tiles.TileCrucible;
import exnihiloadscensio.tiles.TileInfestedLeaves;
import exnihiloadscensio.tiles.TileSieve;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class CompatWaila
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tile;
        TileBarrel barrel;
        if (accessor.getBlock() instanceof BlockBarrel && (barrel = (TileBarrel)accessor.getTileEntity()).getMode() != null) {
            currenttip = barrel.getMode().getWailaTooltip(barrel, currenttip);
        }
        if (accessor.getBlock() instanceof BlockSieve) {
            TileSieve sieve = (TileSieve)accessor.getTileEntity();
            if (sieve.getMeshStack() != null) {
                currenttip.add("Mesh: " + I18n.func_135052_a((String)(sieve.getMeshStack().func_77977_a() + ".name"), (Object[])new Object[0]));
            } else {
                currenttip.add("Mesh: None");
            }
        }
        if (accessor.getBlock() instanceof BlockInfestedLeaves) {
            tile = (TileInfestedLeaves)accessor.getTileEntity();
            if (tile.getProgress() >= 1.0f) {
                currenttip.add("Progress: Done");
            } else {
                currenttip.add("Progress: " + Math.round(100.0f * tile.getProgress()) + "%");
            }
        }
        if (accessor.getBlock() instanceof BlockCrucible) {
            tile = (TileCrucible)accessor.getTileEntity();
            ItemStack solid = tile.getCurrentItem() == null ? null : tile.getCurrentItem().getItemStack();
            FluidStack liquid = tile.getTank().getFluid();
            String solidName = solid == null ? "None" : solid.func_82833_r();
            String liquidName = liquid == null ? "None" : liquid.getLocalizedName();
            int solidAmount = Math.max(0, tile.getSolidAmount());
            ItemStack toMelt = tile.getItemHandler().getStackInSlot(0);
            if (toMelt != null) {
                solidAmount += CrucibleRegistry.getMeltable(toMelt).getAmount() * toMelt.field_77994_a;
            }
            currenttip.add(String.format("Solid (%s): %d", solidName, solidAmount));
            currenttip.add(String.format("Liquid (%s): %d", liquidName, tile.getTank().getFluidAmount()));
            currenttip.add("Rate: " + tile.getHeatRate() + "x");
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        CompatWaila instance = new CompatWaila();
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockBarrel.class);
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockSieve.class);
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockInfestedLeaves.class);
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockCrucible.class);
    }
}

