/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.blocks;

import exnihiloadscensio.barrel.modes.block.BarrelModeBlock;
import exnihiloadscensio.barrel.modes.compost.BarrelModeCompost;
import exnihiloadscensio.barrel.modes.fluid.BarrelModeFluid;
import exnihiloadscensio.barrel.modes.transform.BarrelModeFluidTransform;
import exnihiloadscensio.blocks.BlockBase;
import exnihiloadscensio.compatibility.theoneprobe.ITOPInfoProvider;
import exnihiloadscensio.config.Config;
import exnihiloadscensio.tiles.TileBarrel;
import exnihiloadscensio.util.Util;
import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.StringUtils;

public class BlockBarrel
extends BlockBase
implements ITileEntityProvider,
ITOPInfoProvider {
    private AxisAlignedBB boundingBox = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
    private int tier;

    public BlockBarrel(int tier, Material material) {
        super(material, "blockBarrel" + tier);
        this.tier = tier;
        this.func_149711_c(2.0f);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        ItemStack stack;
        TileBarrel barrel;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileBarrel && (barrel = (TileBarrel)te).getMode() != null && barrel.getMode().getName().equals("block") && (stack = ((IItemHandler)barrel.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0)) != null) {
            Util.dropItemInWorld(te, null, stack, 0.0);
        }
        super.func_180663_b(world, pos, state);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileBarrel) {
            TileBarrel tile = (TileBarrel)te;
            if (tile.getMode() instanceof BarrelModeBlock) {
                BarrelModeBlock mode = (BarrelModeBlock)tile.getMode();
                if (mode.getBlock() != null) {
                    return Block.func_149634_a((Item)mode.getBlock().getItem()).func_176203_a(mode.getBlock().getMeta()).func_185906_d();
                }
            } else if (tile.getMode() instanceof BarrelModeFluid) {
                BarrelModeFluid mode = (BarrelModeFluid)tile.getMode();
                if (mode.getFluidHandler(tile).getFluidAmount() > 0) {
                    return Util.getLightValue(mode.getFluidHandler(tile).getFluid());
                }
            } else if (Config.enableBarrelTransformLighting) {
                if (tile.getMode() instanceof BarrelModeCompost) {
                    BarrelModeCompost mode = (BarrelModeCompost)tile.getMode();
                    if (mode.getCompostState() != null) {
                        int value = mode.getCompostState().func_185906_d() / 2;
                        return Math.round(Util.weightedAverage(value / 2, value, mode.getProgress()));
                    }
                } else if (tile.getMode() instanceof BarrelModeFluidTransform) {
                    BarrelModeFluidTransform mode = (BarrelModeFluidTransform)tile.getMode();
                    int inputValue = Util.getLightValue(mode.getInputStack());
                    int outputValue = Util.getLightValue(mode.getOutputStack());
                    return Math.round(Util.weightedAverage(outputValue, inputValue, mode.getProgress()));
                }
            }
        }
        return super.getLightValue(state, world, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        return ((TileBarrel)world.func_175625_s(pos)).onBlockActivated(world, pos, state, player, side, hitX, hitY, hitZ);
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileBarrel(this);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.boundingBox;
    }

    public boolean func_176212_b(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileBarrel barrel = (TileBarrel)world.func_175625_s(data.getPos());
        if (barrel == null) {
            return;
        }
        if (mode == ProbeMode.EXTENDED) {
            probeInfo.text(TextFormatting.GREEN + "Mode: " + StringUtils.capitalize((String)barrel.getMode().getName()));
        }
        List<String> tooltips = barrel.getMode().getWailaTooltip(barrel, new ArrayList<String>());
        for (String tooltip : tooltips) {
            probeInfo.text(tooltip);
        }
    }

    public int getTier() {
        return this.tier;
    }
}

