/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.eventHandlers;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.ModBlocks;
import ganymedes01.headcrumbs.entity.EntityHuman;
import ganymedes01.headcrumbs.entity.vip.direwolf20;
import ganymedes01.headcrumbs.libs.CelebrityMap;
import ganymedes01.headcrumbs.tileentities.TileEntityBlockPlayer;
import ganymedes01.headcrumbs.utils.HeadUtils;
import ganymedes01.headcrumbs.utils.Utils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HandlerEvents {
    public static final HandlerEvents INSTANCE = new HandlerEvents();
    private static List<String> hardcodedBlacklist = Arrays.asList("Twilight Forest", "Erebus", "The Outer Lands");
    private BlockPattern statuePattern;

    private HandlerEvents() {
    }

    @SubscribeEvent
    public void onRegisterLootTable(LootTableLoadEvent event) {
        HeadUtils.onRegisterLootTable(event);
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack stack;
        Entity attacker;
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource dmgSrc = event.getSource();
        if (dmgSrc != null && entity instanceof EntityHuman && (attacker = dmgSrc.func_76346_g()) instanceof EntityPlayer && (stack = (player = (EntityPlayer)attacker).func_184586_b(EnumHand.MAIN_HAND)) != null && stack.func_77973_b() == Items.field_151055_y) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("IsDirestick")) {
                direwolf20.takeItEasy(player);
            } else {
                direwolf20.makeDirestick((EntityHuman)entity, player, stack);
            }
        }
    }

    @SubscribeEvent
    public void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntityLiving() instanceof EntityHuman) {
            World world = event.getWorld();
            DimensionType dimType = world.field_73011_w.func_186058_p();
            if (hardcodedBlacklist.contains(dimType.func_186065_b()) || HandlerEvents.isDimensionBlackListed(dimType.func_186068_a())) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    private static boolean isDimensionBlackListed(int dimensionId) {
        for (int id : Headcrumbs.blacklistedDimensions) {
            if (dimensionId != id) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropEvent(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        List drops = event.getDrops();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.func_110143_aJ() > 0.0f) {
            return;
        }
        if (this.isPoweredCreeper(source)) {
            ItemStack stack = HeadUtils.getHeadfromEntity(entity);
            if (stack == null) {
                return;
            }
            EntityItem entityItem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
            entityItem.func_174869_p();
            drops.add(entityItem);
        }
    }

    private boolean isPoweredCreeper(DamageSource source) {
        Entity entity;
        if (source.func_94541_c() && source instanceof EntityDamageSource && (entity = ((EntityDamageSource)source).func_76346_g()) != null && entity instanceof EntityCreeper) {
            return ((EntityCreeper)entity).func_70830_n();
        }
        return false;
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        String tip;
        String name;
        if (!Headcrumbs.enableTooltips) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack != null && stack.func_77973_b() == Items.field_151144_bL && stack.func_77960_j() == 3 && (name = HeadUtils.getName(stack)) != null && !StringUtils.func_151246_b((String)(tip = CelebrityMap.getTooltip(name)))) {
            event.getToolTip().add(tip);
        }
    }

    @SubscribeEvent
    public void onSkullPlacedEvent(BlockEvent.PlaceEvent event) {
        TileEntitySkull tileSkull;
        BlockPos pos;
        if (event.getState().func_177230_c() != Blocks.field_150465_bP) {
            return;
        }
        World world = event.getWorld();
        TileEntity tileEntity = world.func_175625_s(pos = event.getPos());
        if (tileEntity instanceof TileEntitySkull && (tileSkull = (TileEntitySkull)tileEntity).func_145904_a() == 3 && pos.func_177956_o() >= 2 && world.func_175659_aa() != EnumDifficulty.PEACEFUL && !world.field_72995_K) {
            BlockPattern.PatternHelper patternHelper;
            if (this.statuePattern == null) {
                this.statuePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"^", "#", "#"}).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150435_aG))).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150465_bP))).func_177661_b();
            }
            if ((patternHelper = this.statuePattern.func_177681_a(world, pos)) != null) {
                GameProfile profile = tileSkull.func_152108_a();
                for (int i = 0; i < 3; ++i) {
                    BlockWorldState blockWorldState = patternHelper.func_177670_a(0, -i, 0);
                    world.func_180501_a(blockWorldState.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                }
                world.func_175656_a(pos.func_177982_a(0, -1, 0), ModBlocks.player.func_176223_P());
                Utils.doBreakParticles(world, pos.func_177982_a(0, -1, 0), Blocks.field_150425_aM, 0);
                world.func_175656_a(pos.func_177982_a(0, -2, 0), ModBlocks.empty.func_176223_P());
                Utils.doBreakParticles(world, pos.func_177982_a(0, -2, 0), Blocks.field_150425_aM, 0);
                TileEntityBlockPlayer tile = Utils.getTileEntity((IBlockAccess)world, pos.func_177982_a(0, -1, 0), TileEntityBlockPlayer.class);
                if (tile != null) {
                    tile.func_152106_a(profile);
                    tile.func_145903_a(MathHelper.func_76128_c((double)((double)(event.getPlayer().field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF);
                    world.func_180496_d(pos.func_177982_a(0, -1, 0), ModBlocks.player);
                }
            }
        }
    }
}

