/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.entity;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.api.IHumanEntity;
import ganymedes01.headcrumbs.entity.EntityAIAttackBow;
import ganymedes01.headcrumbs.entity.VIPHandler;
import ganymedes01.headcrumbs.utils.ThreadedProfileFiller;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class EntityHuman
extends EntityMob
implements IRangedAttackMob,
IHumanEntity {
    private double prevCapeX;
    private double prevCapeY;
    private double prevCapeZ;
    private double capeX;
    private double capeY;
    private double capeZ;
    private GameProfile profile;
    private ResourceLocation skin;
    private ResourceLocation cape;
    private boolean skinAvailable = false;
    private boolean capeAvailable = false;
    private boolean profileReady = false;
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836"), "Baby speed boost", 0.5, 1);
    private final EntityAIBase breakDoorAI = new EntityAIBreakDoor((EntityLiving)this);
    private final EntityAIBase arrowAI = new EntityAIAttackBow(this, 1.0, 20, 15.0f);
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(EntityHuman.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> CHILD = EntityDataManager.func_187226_a(EntityHuman.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> WIDTH = EntityDataManager.func_187226_a(EntityHuman.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> HEIGHT = EntityDataManager.func_187226_a(EntityHuman.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> DRAWING_BOW = EntityDataManager.func_187226_a(EntityHuman.class, (DataSerializer)DataSerializers.field_187198_h);
    private static List<String> names = new LinkedList<String>();

    public EntityHuman(World world) {
        super(world);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        if (world.func_175659_aa() == EnumDifficulty.HARD) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        }
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, (Predicate)new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                return Headcrumbs.humansAttackTwins || !input.func_70005_c_().equals(EntityHuman.this.getUsername());
            }
        }));
        this.func_70105_a(0.6f, 1.8f);
    }

    public boolean func_98052_bS() {
        return true;
    }

    public void func_70071_h_() {
        this.prevCapeX = this.capeX;
        this.prevCapeY = this.capeY;
        this.prevCapeZ = this.capeZ;
        double x = this.field_70165_t - this.capeX;
        double y = this.field_70163_u - this.capeY;
        double z = this.field_70161_v - this.capeZ;
        double maxCapeAngle = 10.0;
        if (x > maxCapeAngle) {
            this.prevCapeX = this.capeX = this.field_70165_t;
        }
        if (z > maxCapeAngle) {
            this.prevCapeZ = this.capeZ = this.field_70161_v;
        }
        if (y > maxCapeAngle) {
            this.prevCapeY = this.capeY = this.field_70163_u;
        }
        if (x < -maxCapeAngle) {
            this.prevCapeX = this.capeX = this.field_70165_t;
        }
        if (z < -maxCapeAngle) {
            this.prevCapeZ = this.capeZ = this.field_70161_v;
        }
        if (y < -maxCapeAngle) {
            this.prevCapeY = this.capeY = this.field_70163_u;
        }
        this.capeX += x * 0.25;
        this.capeZ += z * 0.25;
        this.capeY += y * 0.25;
        if (this.field_70170_p.field_72995_K) {
            float h;
            float w = ((Float)this.field_70180_af.func_187225_a(WIDTH)).floatValue();
            if (w != this.field_70130_N) {
                this.field_70130_N = w;
            }
            if ((h = ((Float)this.field_70180_af.func_187225_a(HEIGHT)).floatValue()) != this.field_70131_O) {
                this.field_70131_O = h;
            }
        }
        super.func_70071_h_();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(NAME, (Object)"");
        this.field_70180_af.func_187214_a(CHILD, (Object)false);
        this.field_70180_af.func_187214_a(WIDTH, (Object)Float.valueOf(this.field_70130_N));
        this.field_70180_af.func_187214_a(HEIGHT, (Object)Float.valueOf(this.field_70131_O));
        this.field_70180_af.func_187214_a(DRAWING_BOW, (Object)false);
    }

    protected SoundEvent func_184639_G() {
        return this.getVIPHandler().getAmbientSound();
    }

    protected SoundEvent func_184601_bQ() {
        return this.getVIPHandler().hurtSound();
    }

    protected SoundEvent func_184615_bR() {
        return this.getVIPHandler().deathSound();
    }

    protected void func_70628_a(boolean recentHit, int looting) {
        this.getVIPHandler().dropItems(this, looting);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.1f : 0.05f;
        if (f < f2) {
            int i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70146_Z.nextFloat() > 0.5f) {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_185159_cQ));
                    this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Shield Bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
                }
            } else if (i == 1) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70146_Z.nextFloat() > 0.5f) {
                    ArrayList keys = new ArrayList(PotionType.field_185176_a.func_148742_b());
                    ResourceLocation key = (ResourceLocation)keys.get(this.field_70146_Z.nextInt(keys.size()));
                    PotionType potion = (PotionType)PotionType.field_185176_a.func_82594_a((Object)key);
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)potion));
                }
            }
        }
    }

    public void func_184201_a(EntityEquipmentSlot slot, ItemStack stack) {
        super.func_184201_a(slot, stack);
        this.setCombatAI();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack stack = new ItemStack(Items.field_151063_bx);
        ItemMonsterPlacer.func_185078_a((ItemStack)stack, (String)((String)EntityList.field_75626_c.get(this.getClass())));
        return stack;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.setUsername(EntityHuman.getRandomUsername(this.field_70146_Z));
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        this.setCombatAI();
        float additionalDifficulty = difficulty.func_180170_c();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Knockback Resistance Bonus", this.field_70146_Z.nextDouble() * 0.05, 0));
        double rangeBonus = this.field_70146_Z.nextDouble() * 1.5 * (double)additionalDifficulty;
        if (rangeBonus > 1.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Range Bonus", rangeBonus, 2));
        }
        if (this.field_70146_Z.nextFloat() < additionalDifficulty * 0.05f) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Health Bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
        }
        if (this.field_70146_Z.nextFloat() < additionalDifficulty * 0.15f) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("Damage Bonus", this.field_70146_Z.nextDouble() + 0.5, 2));
        }
        if (this.field_70146_Z.nextFloat() < additionalDifficulty * 0.2f) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier("Speed Bonus", this.field_70146_Z.nextDouble() * 2.0 * 0.24 + 0.01, 2));
        }
        if (this.field_70146_Z.nextDouble() < Headcrumbs.babyHumanChance) {
            this.setChild(true);
        }
        if (this.field_70146_Z.nextFloat() < additionalDifficulty * 0.1f) {
            this.field_70714_bg.func_75776_a(1, this.breakDoorAI);
        }
        this.getVIPHandler().onSpawn(this, difficulty);
        return null;
    }

    protected void func_70623_bb() {
        super.func_70623_bb();
        Entity ridingEntity = this.func_184187_bx();
        if (this.field_70128_L && ridingEntity != null) {
            ridingEntity.func_70106_y();
        }
    }

    public double func_70033_W() {
        return -0.3;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        String username = this.getUsername();
        if (!StringUtils.isBlank((CharSequence)username)) {
            nbt.func_74778_a("Username", username);
        }
        if (this.func_70631_g_()) {
            nbt.func_74757_a("IsBaby", true);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        String username;
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("Username")) {
            username = nbt.func_74779_i("Username");
            EntityHuman.getNames().remove(username);
        } else {
            username = EntityHuman.getRandomUsername(this.field_70146_Z);
        }
        this.setUsername(username);
        if (nbt.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        this.setCombatAI();
    }

    public boolean func_70652_k(Entity target) {
        boolean result = super.func_70652_k(target);
        if (result) {
            this.func_184609_a(EnumHand.MAIN_HAND);
        }
        return result;
    }

    public void func_82196_d(EntityLivingBase target, float damage) {
        if (!this.hasBow()) {
            return;
        }
        EntityTippedArrow arrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        ItemStack offHandStack = this.func_184582_a(EntityEquipmentSlot.OFFHAND);
        if (offHandStack != null && offHandStack.func_77973_b() == Items.field_185167_i) {
            arrow.func_184555_a(offHandStack);
        }
        double x = target.field_70165_t - this.field_70165_t;
        double y = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - arrow.field_70163_u;
        double z = target.field_70161_v - this.field_70161_v;
        double d0 = MathHelper.func_76133_a((double)(x * x + z * z));
        arrow.func_70186_c(x, y + d0 * 0.2, z, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        int power = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)this);
        int punch = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)this);
        arrow.func_70239_b((double)(damage * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (power > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        if (punch > 0) {
            arrow.func_70240_a(punch);
        }
        if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (EntityLivingBase)this) > 0) {
            arrow.func_70015_d(100);
        }
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    private boolean hasBow() {
        ItemStack stack = this.func_184586_b(EnumHand.MAIN_HAND);
        return stack != null && stack.func_77973_b() instanceof ItemBow;
    }

    private void setCombatAI() {
        if (this.hasBow()) {
            this.field_70714_bg.func_75776_a(1, this.arrowAI);
        } else {
            this.field_70714_bg.func_85156_a(this.arrowAI);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isDrawingBow() {
        return (Boolean)this.field_70180_af.func_187225_a(DRAWING_BOW);
    }

    public void setDrawingBow(boolean flag) {
        this.field_70180_af.func_187227_b(DRAWING_BOW, (Object)flag);
    }

    private VIPHandler getVIPHandler() {
        return VIPHandler.getHandler(this.getUsername());
    }

    public String func_70005_c_() {
        return this.getUsername();
    }

    public String func_95999_t() {
        return this.getUsername();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_()){
            private Style style;

            public Style func_150256_b() {
                if (this.style == null) {
                    this.style = new Style(){

                        @SideOnly(value=Side.CLIENT)
                        public String func_150218_j() {
                            return Headcrumbs.humanNamePrefix;
                        }
                    };
                    for (ITextComponent ichatcomponent : this.field_150264_a) {
                        ichatcomponent.func_150256_b().func_150221_a(this.style);
                    }
                }
                return this.style;
            }
        };
    }

    public void func_96094_a(String name) {
    }

    public static String getRandomUsername(Random rand) {
        List<String> names = EntityHuman.getNames();
        String username = names.get(rand.nextInt(names.size()));
        names.remove(username);
        return username;
    }

    public static List<String> getNames() {
        if (names.isEmpty()) {
            names.addAll(Headcrumbs.getAllNames());
        }
        return names;
    }

    @Override
    public GameProfile getProfile() {
        if (this.profile == null) {
            this.profile = new GameProfile(null, this.getUsername());
            ThreadedProfileFiller.updateProfile(this);
        }
        return this.profile;
    }

    @Override
    public void setProfile(GameProfile profile) {
        this.profile = profile;
        this.profileReady = true;
    }

    @Override
    public String getUsername() {
        return (String)this.field_70180_af.func_187225_a(NAME);
    }

    @Override
    public void setUsername(String name) {
        this.field_70180_af.func_187227_b(NAME, (Object)name);
        if ("Herobrine".equals(name)) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("Herobrine Damage Bonus", 1.0, 2));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier("Herobrine Speed Bonus", 0.5, 2));
        }
        this.getProfile();
    }

    @Override
    public double getInterpolatedCapeX(float partialTickTime) {
        return this.prevCapeX + (this.capeX - this.prevCapeX) * (double)partialTickTime - (this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTickTime);
    }

    @Override
    public double getInterpolatedCapeY(float partialTickTime) {
        return this.prevCapeY + (this.capeY - this.prevCapeY) * (double)partialTickTime - (this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTickTime);
    }

    @Override
    public double getInterpolatedCapeZ(float partialTickTime) {
        return this.prevCapeZ + (this.capeZ - this.prevCapeZ) * (double)partialTickTime - (this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTickTime);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SkinManager.SkinAvailableCallback getCallback() {
        return new SkinManager.SkinAvailableCallback(){

            public void func_180521_a(MinecraftProfileTexture.Type type, ResourceLocation location, MinecraftProfileTexture profileTexture) {
                switch (type) {
                    case CAPE: {
                        EntityHuman.this.cape = location;
                        break;
                    }
                    default: {
                        EntityHuman.this.skin = location;
                    }
                }
                EntityHuman.this.setTextureAvailable(type);
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isTextureAvailable(MinecraftProfileTexture.Type type) {
        switch (type) {
            case CAPE: {
                return this.capeAvailable;
            }
        }
        return this.skinAvailable;
    }

    @SideOnly(value=Side.CLIENT)
    private void setTextureAvailable(MinecraftProfileTexture.Type type) {
        switch (type) {
            case CAPE: {
                this.capeAvailable = true;
                break;
            }
            default: {
                this.skinAvailable = true;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTexture(MinecraftProfileTexture.Type type) {
        switch (type) {
            case CAPE: {
                return this.cape;
            }
        }
        return this.skin;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isProfileReady() {
        return this.profileReady;
    }

    public boolean func_70631_g_() {
        return (Boolean)this.field_70180_af.func_187225_a(CHILD);
    }

    public void setChild(boolean isChild) {
        this.field_70180_af.func_187227_b(CHILD, (Object)isChild);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance speed = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            speed.func_111124_b(babySpeedBoostModifier);
            if (isChild) {
                speed.func_111121_a(babySpeedBoostModifier);
            }
        }
        if (isChild) {
            this.func_70105_a(this.field_70130_N * 0.5f, this.field_70131_O * 0.5f);
        }
    }

    protected void func_70105_a(float width, float height) {
        super.func_70105_a(width, height);
        this.field_70180_af.func_187227_b(WIDTH, (Object)Float.valueOf(this.field_70130_N));
        this.field_70180_af.func_187227_b(HEIGHT, (Object)Float.valueOf(this.field_70131_O));
    }
}

