/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CompoundCapabilityProvider
implements ICapabilityProvider {
    private final List<ICapabilityProvider> providers = new ArrayList<ICapabilityProvider>();

    public CompoundCapabilityProvider(ICapabilityProvider ... provs) {
        if (provs != null) {
            for (ICapabilityProvider p : provs) {
                if (p == null) continue;
                this.providers.add(p);
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        for (ICapabilityProvider prov : this.providers) {
            if (!prov.hasCapability(capability, facing)) continue;
            return true;
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        for (ICapabilityProvider prov : this.providers) {
            Object res = prov.getCapability(capability, facing);
            if (res == null) continue;
            return (T)res;
        }
        return null;
    }
}

