/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.widget;

import com.enderio.core.client.gui.widget.GhostSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GhostBackgroundItemSlot
extends GhostSlot {
    private ItemStack stack;
    private final List<ItemStack> stacks;
    private int idx = 999;
    private final Slot parent;
    private long lastSwitch = 0L;

    private GhostBackgroundItemSlot(ItemStack stack, List<ItemStack> stacks, Slot parent, int x, int y) {
        this.stack = stack;
        this.stacks = stack == null && stacks != null && !stacks.isEmpty() ? new ArrayList<ItemStack>(stacks) : null;
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.grayOut = true;
        this.grayOutLevel = 0.75f;
    }

    public GhostBackgroundItemSlot(ItemStack stack, int x, int y) {
        this(stack, null, null, x, y);
    }

    public GhostBackgroundItemSlot(List<ItemStack> stacks, int x, int y) {
        this(null, stacks, null, x, y);
    }

    public GhostBackgroundItemSlot(ItemStack stack, Slot parent) {
        this(stack, null, parent, parent.field_75223_e, parent.field_75221_f);
    }

    public GhostBackgroundItemSlot(List<ItemStack> stacks, Slot parent) {
        this(null, stacks, parent, parent.field_75223_e, parent.field_75221_f);
    }

    public GhostBackgroundItemSlot(Item item, int x, int y) {
        this(new ItemStack(item), x, y);
    }

    public GhostBackgroundItemSlot(Block block, int x, int y) {
        this(new ItemStack(block), x, y);
    }

    public GhostBackgroundItemSlot(Item item, Slot parent) {
        this(new ItemStack(item), parent);
    }

    public GhostBackgroundItemSlot(Block block, Slot parent) {
        this(new ItemStack(block), parent);
    }

    @Override
    public boolean isMouseOver(int mx, int my) {
        return false;
    }

    @Override
    public ItemStack getStack() {
        if (this.stacks != null && Minecraft.func_71386_F() - this.lastSwitch > 1000L) {
            this.lastSwitch = Minecraft.func_71386_F();
            if (++this.idx >= this.stacks.size()) {
                this.idx = 0;
                Collections.shuffle(this.stacks);
            }
            this.stack = this.stacks.get(this.idx);
        }
        return this.stack;
    }

    @Override
    public void putStack(ItemStack stackIn) {
    }

    @Override
    public boolean isVisible() {
        return this.parent != null ? this.parent.field_75223_e >= 0 && this.parent.field_75221_f >= 0 && !this.parent.func_75216_d() && super.isVisible() : super.isVisible();
    }
}

