/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.util.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class RenderUtils {
    static Gui gui = new Gui();
    static Cache<String, Integer> biomeColorCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    public static int getBiomeColor(IBlockAccess worldIn, final Biome biome, final BlockPos pos) {
        if (worldIn != null) {
            int i = 0;
            int j = 0;
            int k = 0;
            for (final BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 0, 1))) {
                final Biome biomeA = worldIn.func_180494_b((BlockPos)blockpos$mutableblockpos);
                int l = Color.WHITE.getRGB();
                try {
                    l = (Integer)biomeColorCache.get((Object)((ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biomeA)).toString(), (Callable)new Callable<Integer>(){

                        @Override
                        public Integer call() throws Exception {
                            BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((Biome)biomeA);
                            Color foliageColor = new Color(biomeA.func_180625_c((BlockPos)blockpos$mutableblockpos));
                            Color waterColorMultiplier = new Color(biomeA.getWaterColorMultiplier());
                            Color grassColor = new Color(biomeA.func_180627_b((BlockPos)blockpos$mutableblockpos));
                            Color colorResult = RenderUtils.blend(RenderUtils.blend(foliageColor, waterColorMultiplier, 0.5f), grassColor, 0.5f);
                            block31: for (BiomeDictionary.Type t : types) {
                                switch (t) {
                                    case BEACH: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.35f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.3f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.1f)));
                                        continue block31;
                                    }
                                    case COLD: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.8f)), Math.min(255, colorResult.getGreen()), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                        continue block31;
                                    }
                                    case CONIFEROUS: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.1f)), Math.min(255, colorResult.getBlue()));
                                        continue block31;
                                    }
                                    case DEAD: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.8f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.8f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                        continue block31;
                                    }
                                    case DENSE: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.0f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.5f)), Math.min(255, colorResult.getBlue()));
                                        continue block31;
                                    }
                                    case DRY: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.1f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                        continue block31;
                                    }
                                    case END: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.1f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.4f)));
                                        continue block31;
                                    }
                                    case FOREST: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.8f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.9f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                        continue block31;
                                    }
                                    case HILLS: {
                                        colorResult = new Color(Math.min(255, colorResult.getRed() + 40), Math.min(255, colorResult.getGreen() + 40), Math.min(255, colorResult.getBlue() + 40));
                                        continue block31;
                                    }
                                    case HOT: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.1f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.0f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                        continue block31;
                                    }
                                    case JUNGLE: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.1f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.5f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                        continue block31;
                                    }
                                    case LUSH: {
                                        colorResult = new Color(Math.min(255, colorResult.getRed()), Math.min(255, (int)((float)colorResult.getGreen() * 1.4f)), Math.min(255, colorResult.getBlue()));
                                        continue block31;
                                    }
                                    case MAGICAL: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.5f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.3f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.5f)));
                                        continue block31;
                                    }
                                    case MESA: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.9f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.8f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.5f)));
                                        continue block31;
                                    }
                                    case MOUNTAIN: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.2f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                        continue block31;
                                    }
                                    case MUSHROOM: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.3f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.5f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.3f)));
                                        continue block31;
                                    }
                                    case NETHER: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.8f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.5f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.3f)));
                                        continue block31;
                                    }
                                    case OCEAN: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.4f)), Math.min(255, colorResult.getBlue()));
                                        continue block31;
                                    }
                                    case PLAINS: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.9f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.9f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.9f)));
                                        continue block31;
                                    }
                                    case RIVER: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.6f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.6f)), Math.min(255, colorResult.getBlue()));
                                        continue block31;
                                    }
                                    case SANDY: {
                                        colorResult = new Color(Math.min(255, (int)((double)colorResult.getRed() * 0.8)), Math.min(255, (int)((double)colorResult.getGreen() * 0.8)), Math.min(255, (int)((float)colorResult.getBlue() * 0.7f)));
                                        continue block31;
                                    }
                                    case SAVANNA: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.1f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.9f)));
                                        continue block31;
                                    }
                                    case SNOWY: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.4f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.5f)));
                                        continue block31;
                                    }
                                    case SPARSE: {
                                        colorResult = new Color(Math.min(255, colorResult.getRed()), Math.min(255, (int)((float)colorResult.getGreen() * 0.8f)), Math.min(255, colorResult.getBlue()));
                                        continue block31;
                                    }
                                    case SPOOKY: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.7f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.7f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.7f)));
                                        continue block31;
                                    }
                                    case SWAMP: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.6f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.4f)));
                                        continue block31;
                                    }
                                    case WASTELAND: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.2f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                        continue block31;
                                    }
                                    case WATER: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.5f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.5f)), Math.min(255, colorResult.getBlue()));
                                        continue block31;
                                    }
                                    case WET: {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.6f)), Math.min(255, colorResult.getGreen()), Math.min(255, colorResult.getBlue()));
                                        continue block31;
                                    }
                                }
                            }
                            return colorResult.getRGB();
                        }
                    });
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                i += (l & 0xFF0000) >> 16;
                j += (l & 0xFF00) >> 8;
                k += l & 0xFF;
            }
            return (i / 9 & 0xFF) << 16 | (j / 9 & 0xFF) << 8 | k / 9 & 0xFF;
        }
        try {
            return (Integer)biomeColorCache.get((Object)((ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome)).toString(), (Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((Biome)biome);
                    Color foliageColor = new Color(biome.func_180625_c(pos));
                    Color waterColorMultiplier = new Color(biome.getWaterColorMultiplier());
                    Color grassColor = new Color(biome.func_180627_b(pos));
                    Color colorResult = RenderUtils.blend(RenderUtils.blend(foliageColor, waterColorMultiplier, 0.5f), grassColor, 0.5f);
                    block31: for (BiomeDictionary.Type t : types) {
                        switch (t) {
                            case BEACH: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.35f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.3f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.1f)));
                                continue block31;
                            }
                            case COLD: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.8f)), Math.min(255, colorResult.getGreen()), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                continue block31;
                            }
                            case CONIFEROUS: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.1f)), Math.min(255, colorResult.getBlue()));
                                continue block31;
                            }
                            case DEAD: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.8f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.8f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                continue block31;
                            }
                            case DENSE: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.0f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.5f)), Math.min(255, colorResult.getBlue()));
                                continue block31;
                            }
                            case DRY: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.1f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                continue block31;
                            }
                            case END: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.1f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.4f)));
                                continue block31;
                            }
                            case FOREST: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.8f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.9f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                continue block31;
                            }
                            case HILLS: {
                                colorResult = new Color(Math.min(255, colorResult.getRed() + 40), Math.min(255, colorResult.getGreen() + 40), Math.min(255, colorResult.getBlue() + 40));
                                continue block31;
                            }
                            case HOT: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.1f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.0f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                continue block31;
                            }
                            case JUNGLE: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.1f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.5f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                continue block31;
                            }
                            case LUSH: {
                                colorResult = new Color(Math.min(255, colorResult.getRed()), Math.min(255, (int)((float)colorResult.getGreen() * 1.4f)), Math.min(255, colorResult.getBlue()));
                                continue block31;
                            }
                            case MAGICAL: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.5f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.3f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.5f)));
                                continue block31;
                            }
                            case MESA: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.9f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.8f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.5f)));
                                continue block31;
                            }
                            case MOUNTAIN: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.2f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                continue block31;
                            }
                            case MUSHROOM: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.3f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.5f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.3f)));
                                continue block31;
                            }
                            case NETHER: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.8f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.5f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.3f)));
                                continue block31;
                            }
                            case OCEAN: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.4f)), Math.min(255, colorResult.getBlue()));
                                continue block31;
                            }
                            case PLAINS: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.9f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.9f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.9f)));
                                continue block31;
                            }
                            case RIVER: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.6f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.6f)), Math.min(255, colorResult.getBlue()));
                                continue block31;
                            }
                            case SANDY: {
                                colorResult = new Color(Math.min(255, (int)((double)colorResult.getRed() * 0.8)), Math.min(255, (int)((double)colorResult.getGreen() * 0.8)), Math.min(255, (int)((float)colorResult.getBlue() * 0.7f)));
                                continue block31;
                            }
                            case SAVANNA: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.1f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.9f)));
                                continue block31;
                            }
                            case SNOWY: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.4f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.5f)));
                                continue block31;
                            }
                            case SPARSE: {
                                colorResult = new Color(Math.min(255, colorResult.getRed()), Math.min(255, (int)((float)colorResult.getGreen() * 0.8f)), Math.min(255, colorResult.getBlue()));
                                continue block31;
                            }
                            case SPOOKY: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.7f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.7f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.7f)));
                                continue block31;
                            }
                            case SWAMP: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.6f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.4f)));
                                continue block31;
                            }
                            case WASTELAND: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.2f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                continue block31;
                            }
                            case WATER: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.5f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.5f)), Math.min(255, colorResult.getBlue()));
                                continue block31;
                            }
                            case WET: {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.6f)), Math.min(255, colorResult.getGreen()), Math.min(255, colorResult.getBlue()));
                                continue block31;
                            }
                        }
                    }
                    return colorResult.getRGB();
                }
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return Color.WHITE.getRGB();
        }
    }

    public static Color blend(Color c1, Color c2, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        int i1 = c1.getRGB();
        int i2 = c2.getRGB();
        int a1 = i1 >> 24 & 0xFF;
        int r1 = (i1 & 0xFF0000) >> 16;
        int g1 = (i1 & 0xFF00) >> 8;
        int b1 = i1 & 0xFF;
        int a2 = i2 >> 24 & 0xFF;
        int r2 = (i2 & 0xFF0000) >> 16;
        int g2 = (i2 & 0xFF00) >> 8;
        int b2 = i2 & 0xFF;
        int a = (int)((float)a1 * iRatio + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        return new Color(a << 24 | r << 16 | g << 8 | b);
    }

    public static void drawCube(float posX, float posY, float posZ, float width, float length, float height, int red, int green, int blue, int alpha) {
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer wr = t.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)posZ);
        wr.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        wr.func_181662_b(0.0, 0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, (double)height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, (double)height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, 0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, (double)height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, (double)height, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, 0.0, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, 0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, (double)height, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, (double)height, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, 0.0, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, 0.0, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, (double)height, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, (double)height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, 0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, 0.0, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, 0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, 0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, 0.0, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, 0.0, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, (double)height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, (double)height, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, (double)height, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, (double)height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
    }

    public static Map<EnumFacing, List<BakedQuad>> getQuadFaceMapFromState(IBlockState state) {
        HashMap<EnumFacing, List<BakedQuad>> map = new HashMap<EnumFacing, List<BakedQuad>>();
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174954_c().func_178125_b(state);
        Random rng = new Random();
        for (EnumFacing f : EnumFacing.values()) {
            map.put(f, model.func_188616_a(state, f, rng.nextLong()));
        }
        map.put(null, model.func_188616_a(state, null, rng.nextLong()));
        return map;
    }

    public static void drawCube(float posX, float posY, float posZ, float size, int red, int green, int blue, int alpha) {
        RenderUtils.drawCube(posX, posY, posZ, size, size, size, red, green, blue, alpha);
    }

    public static void enableDefaultBlending() {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
    }
}

