/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.util;

import baubles.api.BaublesApi;
import java.util.Random;
import lumien.randomthings.util.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.IItemHandler;

public class InventoryUtil {
    public static void dropItemHandlerItems(World worldIn, BlockPos pos, IItemHandler itemHandler) {
        InventoryUtil.dropItemHandlerItems(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), itemHandler);
    }

    private static void dropItemHandlerItems(World worldIn, double x, double y, double z, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemstack = itemHandler.getStackInSlot(i);
            if (itemstack == null) continue;
            WorldUtil.spawnItemStack(worldIn, x, y, z, itemstack);
        }
    }

    public static void shuffleInventory(IInventory inventory) {
        Random rgen = new Random();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int randomPosition = rgen.nextInt(inventory.func_70302_i_());
            ItemStack temp = inventory.func_70301_a(i);
            inventory.func_70299_a(i, inventory.func_70301_a(randomPosition));
            inventory.func_70299_a(randomPosition, temp);
        }
    }

    public static int getInventorySlotContainItem(IInventory inventory, Item i) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack itemInSlot = inventory.func_70301_a(slot);
            if (itemInSlot == null || itemInSlot.func_77973_b() != i) continue;
            return slot;
        }
        return -1;
    }

    public static void writeInventoryToCompound(NBTTagCompound compound, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack is = inventory.func_70301_a(i);
            NBTTagCompound stackNBT = new NBTTagCompound();
            if (is != null) {
                is.func_77955_b(stackNBT);
            } else {
                stackNBT.func_74757_a("empty", true);
            }
            compound.func_74782_a("slot" + i, (NBTBase)stackNBT);
        }
    }

    public static void readInventoryFromCompound(NBTTagCompound compound, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            NBTTagCompound stackNBT = compound.func_74775_l("slot" + i);
            if (stackNBT == null) continue;
            if (stackNBT.func_74764_b("empty")) {
                inventory.func_70299_a(i, null);
                continue;
            }
            inventory.func_70299_a(i, ItemStack.func_77949_a((NBTTagCompound)stackNBT));
        }
    }

    public static ItemStack getPlayerInventoryItem(Item item, EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack is = player.field_71071_by.func_70301_a(i);
            if (is == null || is.func_77973_b() != item) continue;
            return is;
        }
        return null;
    }

    private static ItemStack actuallyGetBauble(Item item, EntityPlayer player) {
        IInventory baublesInventory = BaublesApi.getBaubles((EntityPlayer)player);
        for (int i = 0; i < baublesInventory.func_70302_i_(); ++i) {
            ItemStack is = baublesInventory.func_70301_a(i);
            if (is == null || is.func_77973_b() != item) continue;
            return is;
        }
        return null;
    }

    public static ItemStack getBauble(Item item, EntityPlayer player) {
        if (Loader.isModLoaded((String)"Baubles")) {
            return InventoryUtil.actuallyGetBauble(item, player);
        }
        return null;
    }

    public static boolean isInventoryEmpty(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) == null) continue;
            return false;
        }
        return true;
    }
}

