/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics;

import java.util.List;
import knightminer.ceramics.CommonProxy;
import knightminer.ceramics.blocks.BlockBarrel;
import knightminer.ceramics.blocks.BlockBarrelStained;
import knightminer.ceramics.blocks.BlockClayHard;
import knightminer.ceramics.blocks.BlockClaySlab;
import knightminer.ceramics.blocks.BlockClaySoft;
import knightminer.ceramics.blocks.BlockClayWall;
import knightminer.ceramics.blocks.BlockEnumBase;
import knightminer.ceramics.blocks.BlockStained;
import knightminer.ceramics.blocks.BlockStairsBase;
import knightminer.ceramics.items.ItemArmorClay;
import knightminer.ceramics.items.ItemArmorClayRaw;
import knightminer.ceramics.items.ItemBlockBarrel;
import knightminer.ceramics.items.ItemBlockEnum;
import knightminer.ceramics.items.ItemBlockEnumSlab;
import knightminer.ceramics.items.ItemClayBucket;
import knightminer.ceramics.items.ItemClayShears;
import knightminer.ceramics.items.ItemClayUnfired;
import knightminer.ceramics.library.Config;
import knightminer.ceramics.library.CreativeTab;
import knightminer.ceramics.library.Util;
import knightminer.ceramics.network.CeramicsNetwork;
import knightminer.ceramics.plugin.tconstruct.TConstructPlugin;
import knightminer.ceramics.tileentity.TileBarrel;
import knightminer.ceramics.tileentity.TileBarrelExtension;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemCloth;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ceramics", version="1.10.2-1.1.6b", name="Ceramics", dependencies="after:tconstruct@[1.10.2-2.6.5,);", acceptedMinecraftVersions="[1.10.2]")
public class Ceramics {
    public static final String name = "Ceramics";
    public static final String modID = "ceramics";
    public static final String version = "1.10.2-1.1.6b";
    @SidedProxy(clientSide="knightminer.ceramics.ClientProxy", serverSide="knightminer.ceramics.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTab tab;
    public static final Logger log;
    public static Block clayBarrel;
    public static BlockClaySoft claySoft;
    public static BlockClayHard clayHard;
    public static BlockClaySlab claySlab;
    public static BlockClayWall clayWall;
    public static Block porcelainBarrel;
    public static Block porcelainBarrelExtension;
    public static Block clayBarrelStained;
    public static Block clayBarrelStainedExtension;
    public static Block porcelain;
    public static Block stairsPorcelainBricks;
    public static Block stairsDarkBricks;
    public static Block stairsGoldenBricks;
    public static Block stairsMarineBricks;
    public static Block stairsDragonBricks;
    public static Item clayUnfired;
    public static ItemClayBucket clayBucket;
    public static Item clayShears;
    public static ItemArmor.ArmorMaterial clayArmor;
    public static Item clayHelmet;
    public static Item clayChestplate;
    public static Item clayLeggings;
    public static Item clayBoots;
    public static ItemArmor.ArmorMaterial clayArmorRaw;
    public static Item clayHelmetRaw;
    public static Item clayChestplateRaw;
    public static Item clayLeggingsRaw;
    public static Item clayBootsRaw;
    public static Block porcelainFaucet;
    public static final String[] dyes;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.load(event);
        clayUnfired = Ceramics.registerItem(new ItemClayUnfired(), "unfired_clay");
        clayHard = (BlockClayHard)Ceramics.registerBlock((ItemBlock)new ItemBlockEnum(new BlockClayHard()), "clay_hard");
        claySlab = (BlockClaySlab)Ceramics.registerBlock(new ItemBlockEnumSlab<BlockClayHard.ClayTypeHard>(new BlockClaySlab()), "clay_slab");
        clayWall = (BlockClayWall)Ceramics.registerBlock((ItemBlock)new ItemBlockEnum(new BlockClayWall()), "clay_wall");
        if (Config.porcelainEnabled) {
            claySoft = (BlockClaySoft)Ceramics.registerBlock((ItemBlock)new ItemBlockEnum(new BlockClaySoft()), "clay_soft");
            porcelain = Ceramics.registerBlock((ItemBlock)new ItemBlockEnum(new BlockStained()), "porcelain");
            stairsPorcelainBricks = Ceramics.registerBlockStairsFrom(clayHard, BlockClayHard.ClayTypeHard.PORCELAIN_BRICKS, "porcelain_bricks_stairs");
            Ceramics.oredict(clayUnfired, ItemClayUnfired.UnfiredType.PORCELAIN.getMeta(), "clayPorcelain");
        }
        if (Config.fancyBricksEnabled) {
            stairsDarkBricks = Ceramics.registerBlockStairsFrom(clayHard, BlockClayHard.ClayTypeHard.DARK_BRICKS, "dark_bricks_stairs");
            stairsGoldenBricks = Ceramics.registerBlockStairsFrom(clayHard, BlockClayHard.ClayTypeHard.GOLDEN_BRICKS, "golden_bricks_stairs");
            stairsMarineBricks = Ceramics.registerBlockStairsFrom(clayHard, BlockClayHard.ClayTypeHard.MARINE_BRICKS, "marine_bricks_stairs");
            stairsDragonBricks = Ceramics.registerBlockStairsFrom(clayHard, BlockClayHard.ClayTypeHard.DRAGON_BRICKS, "dragon_bricks_stairs");
        }
        if (Config.bucketEnabled) {
            clayBucket = Ceramics.registerItem(new ItemClayBucket(), "clay_bucket");
            tab.setIcon(new ItemStack((Item)clayBucket));
        }
        if (Config.shearsEnabled) {
            clayShears = Ceramics.registerItem(new ItemClayShears(), "clay_shears");
        }
        if (Config.armorEnabled) {
            clayArmor = EnumHelper.addArmorMaterial((String)Util.prefix("clay"), (String)"cermamics:clay", (int)4, (int[])new int[]{1, 2, 3, 1}, (int)7, null, (float)0.0f);
            Ceramics.clayArmor.customCraftingMaterial = Items.field_151118_aC;
            clayHelmet = Ceramics.registerItem(new ItemArmorClay(EntityEquipmentSlot.HEAD), "clay_helmet");
            clayChestplate = Ceramics.registerItem(new ItemArmorClay(EntityEquipmentSlot.CHEST), "clay_chestplate");
            clayLeggings = Ceramics.registerItem(new ItemArmorClay(EntityEquipmentSlot.LEGS), "clay_leggings");
            clayBoots = Ceramics.registerItem(new ItemArmorClay(EntityEquipmentSlot.FEET), "clay_boots");
            clayArmorRaw = EnumHelper.addArmorMaterial((String)Util.prefix("clay_raw"), (String)"cermamics:clay_raw", (int)1, (int[])new int[]{1, 1, 1, 1}, (int)0, null, (float)0.0f);
            Ceramics.clayArmor.customCraftingMaterial = Items.field_151119_aD;
            clayHelmetRaw = Ceramics.registerItem(new ItemArmorClayRaw(EntityEquipmentSlot.HEAD), "clay_helmet_raw");
            clayChestplateRaw = Ceramics.registerItem(new ItemArmorClayRaw(EntityEquipmentSlot.CHEST), "clay_chestplate_raw");
            clayLeggingsRaw = Ceramics.registerItem(new ItemArmorClayRaw(EntityEquipmentSlot.LEGS), "clay_leggings_raw");
            clayBootsRaw = Ceramics.registerItem(new ItemArmorClayRaw(EntityEquipmentSlot.FEET), "clay_boots_raw");
        }
        if (Config.barrelEnabled) {
            clayBarrel = Ceramics.registerBlock((ItemBlock)new ItemBlockBarrel(new BlockBarrel()), "clay_barrel");
            clayBarrelStained = Ceramics.registerBlock((ItemBlock)new ItemCloth((Block)new BlockBarrelStained(false)), "clay_barrel_stained");
            clayBarrelStainedExtension = Ceramics.registerBlock((ItemBlock)new ItemCloth((Block)new BlockBarrelStained(true)), "clay_barrel_stained_extension");
            if (Config.porcelainEnabled) {
                porcelainBarrel = Ceramics.registerBlock((ItemBlock)new ItemCloth((Block)new BlockBarrelStained(false)), "porcelain_barrel");
                porcelainBarrelExtension = Ceramics.registerBlock((ItemBlock)new ItemCloth((Block)new BlockBarrelStained(true)), "porcelain_barrel_extension");
            }
            Ceramics.registerTE(TileBarrel.class, "barrel");
            Ceramics.registerTE(TileBarrelExtension.class, "barrel_extension");
            Ceramics.oredict(clayBarrel, 0, "barrelClay");
            Ceramics.oredict(clayBarrelStained, "barrelClay");
            Ceramics.oredict(clayBarrel, 1, "barrelExtensionClay");
            Ceramics.oredict(clayBarrelStainedExtension, "barrelExtensionClay");
            Ceramics.oredict(porcelainBarrel, "barrelPorcelain");
            Ceramics.oredict(porcelainBarrelExtension, "barrelExtensionPorcelain");
        }
        if (Loader.isModLoaded((String)"tconstruct")) {
            TConstructPlugin.preInit();
        }
        CeramicsNetwork.registerPackets();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ItemStack raw;
        if (Config.porcelainEnabled) {
            ItemStack porcelainItem = new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.PORCELAIN.getMeta());
            ItemStack brick = new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.PORCELAIN_BRICK.getMeta());
            ItemStack boneMeal = new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b());
            ItemStack block = new ItemStack((Block)claySoft, 1, BlockClaySoft.ClayTypeSoft.PORCELAIN.getMeta());
            ItemStack blockHard = new ItemStack(porcelain, 1, EnumDyeColor.WHITE.func_176765_a());
            ItemStack brickBlock = new ItemStack((Block)clayHard, 1, BlockClayHard.ClayTypeHard.PORCELAIN_BRICKS.getMeta());
            GameRegistry.addShapelessRecipe((ItemStack)porcelainItem, (Object[])new Object[]{Items.field_151119_aD, boneMeal});
            ItemStack porcelainAlt = porcelainItem.func_77946_l();
            porcelainAlt.field_77994_a = 2;
            GameRegistry.addShapelessRecipe((ItemStack)porcelainAlt, (Object[])new Object[]{Items.field_151119_aD, Items.field_151119_aD, Items.field_151128_bU});
            ItemStack porcelainAlt2 = porcelainItem.func_77946_l();
            porcelainAlt2.field_77994_a = 4;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(block, new Object[]{"CC", "CC", Character.valueOf('C'), "clayPorcelain"}));
            GameRegistry.addShapelessRecipe((ItemStack)porcelainAlt2, (Object[])new Object[]{block.func_77946_l()});
            GameRegistry.addRecipe((ItemStack)brickBlock, (Object[])new Object[]{"CC", "CC", Character.valueOf('C'), brick});
            GameRegistry.addSmelting((ItemStack)block.func_77946_l(), (ItemStack)blockHard, (float)0.1f);
            Ceramics.addSlabRecipe((Block)claySlab, BlockClayHard.ClayTypeHard.PORCELAIN_BRICKS.getMeta(), brickBlock);
            Ceramics.addWallRecipe((Block)clayWall, BlockClayWall.ClayWallType.PORCELAIN_BRICKS.getMeta(), brickBlock);
            Ceramics.addStairRecipe(stairsPorcelainBricks, brickBlock);
            for (EnumDyeColor color : EnumDyeColor.values()) {
                ItemStack dyed = new ItemStack(porcelain, 8, color.func_176765_a());
                ItemStack dye = new ItemStack(Items.field_151100_aR, 1, color.func_176767_b());
                GameRegistry.addRecipe((ItemStack)dyed, (Object[])new Object[]{"ccc", "cdc", "ccc", Character.valueOf('d'), dye, Character.valueOf('c'), new ItemStack(porcelain, 1, Short.MAX_VALUE)});
            }
        }
        if (Config.bucketEnabled) {
            raw = new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.BUCKET.getMeta());
            ItemStack milk = new ItemStack((Item)clayBucket, 1, ItemClayBucket.SpecialFluid.MILK.getMeta());
            GameRegistry.addRecipe((ItemStack)raw.func_77946_l(), (Object[])new Object[]{"c c", " c ", Character.valueOf('c'), Items.field_151119_aD});
            GameRegistry.addSmelting((ItemStack)raw, (ItemStack)new ItemStack((Item)clayBucket), (float)0.5f);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151105_aU), new Object[]{"MMM", "SES", "WWW", Character.valueOf('M'), milk, Character.valueOf('S'), Items.field_151102_aT, Character.valueOf('E'), "egg", Character.valueOf('W'), "cropWheat"}));
            GameRegistry.registerFuelHandler((IFuelHandler)new IFuelHandler(){

                public int getBurnTime(ItemStack fuel) {
                    FluidStack fluid;
                    if (fuel != null && fuel.func_77973_b() == clayBucket && (fluid = clayBucket.getFluid(fuel)) != null && fluid.getFluid() == FluidRegistry.LAVA) {
                        return 20000;
                    }
                    return 0;
                }
            });
        }
        if (Config.shearsEnabled) {
            raw = new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.SHEARS.getMeta());
            GameRegistry.addRecipe((ItemStack)raw.func_77946_l(), (Object[])new Object[]{"c ", " c", Character.valueOf('c'), Items.field_151119_aD});
            GameRegistry.addSmelting((ItemStack)raw, (ItemStack)new ItemStack(clayShears), (float)0.5f);
        }
        if (Config.armorEnabled) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(clayHelmetRaw), (Object[])new Object[]{"ccc", "c c", Character.valueOf('c'), Items.field_151119_aD});
            GameRegistry.addRecipe((ItemStack)new ItemStack(clayChestplateRaw), (Object[])new Object[]{"c c", "ccc", "ccc", Character.valueOf('c'), Items.field_151119_aD});
            GameRegistry.addRecipe((ItemStack)new ItemStack(clayLeggingsRaw), (Object[])new Object[]{"ccc", "c c", "c c", Character.valueOf('c'), Items.field_151119_aD});
            GameRegistry.addRecipe((ItemStack)new ItemStack(clayBootsRaw), (Object[])new Object[]{"c c", "c c", Character.valueOf('c'), Items.field_151119_aD});
            GameRegistry.addSmelting((Item)clayHelmetRaw, (ItemStack)new ItemStack(clayHelmet), (float)0.5f);
            GameRegistry.addSmelting((Item)clayChestplateRaw, (ItemStack)new ItemStack(clayChestplate), (float)0.5f);
            GameRegistry.addSmelting((Item)clayLeggingsRaw, (ItemStack)new ItemStack(clayLeggings), (float)0.5f);
            GameRegistry.addSmelting((Item)clayBootsRaw, (ItemStack)new ItemStack(clayBoots), (float)0.5f);
        }
        if (Config.barrelEnabled) {
            raw = new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.BARREL.getMeta());
            ItemStack rawExtension = new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.BARREL_EXTENSION.getMeta());
            GameRegistry.addRecipe((ItemStack)raw.func_77946_l(), (Object[])new Object[]{"c c", "ccc", " c ", Character.valueOf('c'), Items.field_151119_aD});
            GameRegistry.addRecipe((ItemStack)rawExtension.func_77946_l(), (Object[])new Object[]{"c c", "c c", "c c", Character.valueOf('c'), Items.field_151119_aD});
            ItemStack barrel = new ItemStack(clayBarrel, 1, 0);
            ItemStack extension = new ItemStack(clayBarrel, 1, 1);
            GameRegistry.addSmelting((ItemStack)raw, (ItemStack)barrel, (float)0.5f);
            GameRegistry.addSmelting((ItemStack)rawExtension, (ItemStack)extension, (float)0.5f);
            if (Config.porcelainEnabled) {
                ItemStack porcelainRaw = new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.BARREL_PORCELAIN.getMeta());
                ItemStack porcelainRawExtension = new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.BARREL_PORCELAIN_EXTENSION.getMeta());
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(porcelainRaw.func_77946_l(), new Object[]{"c c", "ccc", " c ", Character.valueOf('c'), "clayPorcelain"}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(porcelainRawExtension.func_77946_l(), new Object[]{"c c", "c c", "c c", Character.valueOf('c'), "clayPorcelain"}));
                ItemStack porcelainBarrel2 = new ItemStack(porcelainBarrel, 1, 0);
                ItemStack porcelainExtension = new ItemStack(porcelainBarrelExtension, 1, 0);
                GameRegistry.addSmelting((ItemStack)porcelainRaw, (ItemStack)porcelainBarrel2, (float)0.5f);
                GameRegistry.addSmelting((ItemStack)porcelainRawExtension, (ItemStack)porcelainExtension, (float)0.5f);
            }
            for (ItemStack color : EnumDyeColor.values()) {
                String dye = "dye" + dyes[color.func_176765_a()];
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(clayBarrelStained, 8, color.func_176765_a()), new Object[]{"BBB", "BdB", "BBB", Character.valueOf('B'), "barrelClay", Character.valueOf('d'), dye}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(clayBarrelStainedExtension, 8, color.func_176765_a()), new Object[]{"BBB", "BdB", "BBB", Character.valueOf('B'), "barrelExtensionClay", Character.valueOf('d'), dye}));
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(clayBarrelStained, 1, color.func_176765_a()), new Object[]{"barrelClay", dye}));
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(clayBarrelStainedExtension, 1, color.func_176765_a()), new Object[]{"barrelExtensionClay", dye}));
                if (!Config.porcelainEnabled) continue;
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(porcelainBarrel, 8, color.func_176765_a()), new Object[]{"BBB", "BdB", "BBB", Character.valueOf('B'), "barrelPorcelain", Character.valueOf('d'), dye}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(porcelainBarrelExtension, 8, color.func_176765_a()), new Object[]{"BBB", "BdB", "BBB", Character.valueOf('B'), "barrelExtensionPorcelain", Character.valueOf('d'), dye}));
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(porcelainBarrel, 1, color.func_176765_a()), new Object[]{"barrelPorcelain", dye}));
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(porcelainBarrelExtension, 1, color.func_176765_a()), new Object[]{"barrelExtensionPorcelain", dye}));
            }
        }
        if (Config.fancyBricksEnabled) {
            String[] surround = new String[]{"bbb", "b#b", "bbb"};
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)clayHard, 2, BlockClayHard.ClayTypeHard.DARK_BRICKS.getMeta()), new Object[]{surround, Character.valueOf('b'), Items.field_151118_aC, Character.valueOf('#'), "dyeBlack"}));
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)clayHard, 2, BlockClayHard.ClayTypeHard.DRAGON_BRICKS.getMeta()), (Object[])new Object[]{surround, Character.valueOf('b'), Items.field_151118_aC, Character.valueOf('#'), Items.field_185157_bK});
            Item secondBrick = Items.field_151118_aC;
            if (Config.porcelainEnabled) {
                secondBrick = new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.PORCELAIN_BRICK.getMeta());
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)clayHard, 2, BlockClayHard.ClayTypeHard.MARINE_BRICKS.getMeta()), new Object[]{surround, Character.valueOf('b'), secondBrick, Character.valueOf('#'), "dyeBlue"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)clayHard, 2, BlockClayHard.ClayTypeHard.GOLDEN_BRICKS.getMeta()), new Object[]{surround, Character.valueOf('b'), secondBrick, Character.valueOf('#'), "nuggetGold"}));
            ItemStack darkBricks = new ItemStack((Block)clayHard, 1, BlockClayHard.ClayTypeHard.DARK_BRICKS.getMeta());
            Ceramics.addSlabRecipe((Block)claySlab, BlockClayHard.ClayTypeHard.DARK_BRICKS.getMeta(), darkBricks);
            Ceramics.addWallRecipe((Block)clayWall, BlockClayWall.ClayWallType.DARK_BRICKS.getMeta(), darkBricks);
            Ceramics.addStairRecipe(stairsDarkBricks, darkBricks);
            ItemStack goldenBricks = new ItemStack((Block)clayHard, 1, BlockClayHard.ClayTypeHard.GOLDEN_BRICKS.getMeta());
            Ceramics.addSlabRecipe((Block)claySlab, BlockClayHard.ClayTypeHard.GOLDEN_BRICKS.getMeta(), goldenBricks);
            Ceramics.addWallRecipe((Block)clayWall, BlockClayWall.ClayWallType.GOLDEN_BRICKS.getMeta(), goldenBricks);
            Ceramics.addStairRecipe(stairsGoldenBricks, goldenBricks);
            ItemStack marineBricks = new ItemStack((Block)clayHard, 1, BlockClayHard.ClayTypeHard.MARINE_BRICKS.getMeta());
            Ceramics.addSlabRecipe((Block)claySlab, BlockClayHard.ClayTypeHard.MARINE_BRICKS.getMeta(), marineBricks);
            Ceramics.addWallRecipe((Block)clayWall, BlockClayWall.ClayWallType.MARINE_BRICKS.getMeta(), marineBricks);
            Ceramics.addStairRecipe(stairsMarineBricks, marineBricks);
            ItemStack dragonBricks = new ItemStack((Block)clayHard, 1, BlockClayHard.ClayTypeHard.DRAGON_BRICKS.getMeta());
            Ceramics.addSlabRecipe((Block)claySlab, BlockClayHard.ClayTypeHard.DRAGON_BRICKS.getMeta(), dragonBricks);
            Ceramics.addWallRecipe((Block)clayWall, BlockClayWall.ClayWallType.DRAGON_BRICKS.getMeta(), dragonBricks);
            Ceramics.addStairRecipe(stairsDragonBricks, dragonBricks);
        }
        if (Config.brickWallEnabled) {
            Ceramics.addWallRecipe((Block)clayWall, BlockClayWall.ClayWallType.BRICKS.getMeta(), new ItemStack(Blocks.field_150336_V));
        }
        if (Loader.isModLoaded((String)"tconstruct")) {
            TConstructPlugin.init();
        }
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Config.bucketEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)clayBucket);
        }
        if (Config.shearsEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)clayShears);
        }
        if (Config.porcelainEnabled) {
            List porcelains = OreDictionary.getOres((String)"clayPorcelain", (boolean)false);
            for (ItemStack porcelain : porcelains) {
                ItemStack brick = new ItemStack(clayUnfired, 1, ItemClayUnfired.UnfiredType.PORCELAIN_BRICK.getMeta());
                GameRegistry.addSmelting((ItemStack)porcelain, (ItemStack)brick, (float)0.1f);
            }
        }
        if (Loader.isModLoaded((String)"tconstruct")) {
            TConstructPlugin.postInit();
        }
    }

    @Mod.EventHandler
    public void onMissingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (!Config.bucketEnabled || mapping.type != GameRegistry.Type.ITEM || !mapping.name.equals(Util.resource("clay_bucket_raw"))) continue;
            mapping.remap(clayUnfired);
        }
    }

    public static <T extends Block> T registerBlock(ItemBlock item, String name) {
        Block block = item.func_179223_d();
        block.func_149663_c(Util.prefix(name));
        block.setRegistryName(Util.getResource(name));
        GameRegistry.register((IForgeRegistryEntry)block);
        Ceramics.registerItem(item, name);
        return (T)block;
    }

    protected static <E extends Enum<E> & IStringSerializable> BlockStairsBase registerBlockStairsFrom(BlockEnumBase<E> block, E value, String name) {
        return (BlockStairsBase)((Object)Ceramics.registerBlock(new ItemBlock((Block)new BlockStairsBase(block.func_176223_P().func_177226_a(block.getMappingProperty(), value))), name));
    }

    private static <T extends Item> T registerItem(T item, String name) {
        item.func_77655_b(Util.prefix(name));
        item.setRegistryName(Util.getResource(name));
        GameRegistry.register(item);
        return item;
    }

    protected static void registerTE(Class<? extends TileEntity> teClazz, String name) {
        GameRegistry.registerTileEntity(teClazz, (String)Util.prefix(name));
    }

    public static void oredict(Item item, String ... name) {
        Ceramics.oredict(item, Short.MAX_VALUE, name);
    }

    public static void oredict(Block block, String ... name) {
        Ceramics.oredict(block, Short.MAX_VALUE, name);
    }

    public static void oredict(Item item, int meta, String ... name) {
        Ceramics.oredict(new ItemStack(item, 1, meta), name);
    }

    public static void oredict(Block block, int meta, String ... name) {
        Ceramics.oredict(new ItemStack(block, 1, meta), name);
    }

    public static void oredict(ItemStack stack, String ... names) {
        if (stack != null && stack.func_77973_b() != null) {
            for (String name : names) {
                OreDictionary.registerOre((String)name, (ItemStack)stack);
            }
        }
    }

    protected static void addSlabRecipe(Block slab, int meta, ItemStack input) {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(slab, 6, meta), (Object[])new Object[]{"BBB", Character.valueOf('B'), input});
    }

    protected static void addStairRecipe(Block stairs, ItemStack input) {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(stairs, 4), (Object[])new Object[]{"B  ", "BB ", "BBB", Character.valueOf('B'), input});
    }

    protected static void addWallRecipe(Block wall, int meta, ItemStack input) {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(wall, 6, meta), (Object[])new Object[]{"BBB", "BBB", Character.valueOf('B'), input});
    }

    static {
        tab = new CreativeTab(modID, new ItemStack(Items.field_151118_aC));
        log = LogManager.getLogger((String)modID);
        FluidRegistry.enableUniversalBucket();
        dyes = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
    }
}

