/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.block.tile.mana.TilePrism;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockPrism
extends BlockMod
implements IManaTrigger,
ILexiconable,
IManaCollisionGhost {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private final Random random = new Random();

    public BlockPrism() {
        super(Material.field_151592_s, "prism");
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(1.0f);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.POWERED, BotaniaStateProps.HAS_LENS});
    }

    @Override
    protected IBlockState pickDefaultState() {
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BotaniaStateProps.HAS_LENS, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED) != false ? 8 : 0) + ((Boolean)state.func_177229_b((IProperty)BotaniaStateProps.HAS_LENS) != false ? 1 : 0);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0)).func_177226_a((IProperty)BotaniaStateProps.HAS_LENS, (Comparable)Boolean.valueOf((meta & 1) > 0));
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float par7, float par8, float par9) {
        boolean isHeldItemLens;
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TilePrism)) {
            return false;
        }
        TilePrism prism = (TilePrism)tile;
        ItemStack lens = prism.getItemHandler().getStackInSlot(0);
        boolean bl = isHeldItemLens = heldItem != null && heldItem.func_77973_b() instanceof ILens;
        if (lens == null && isHeldItemLens) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, null);
            }
            prism.getItemHandler().setStackInSlot(0, heldItem.func_77946_l());
            prism.func_70296_d();
            world.func_180501_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.HAS_LENS, (Comparable)Boolean.valueOf(true)), 3);
        } else if (lens != null) {
            ItemStack add = lens.func_77946_l();
            if (!player.field_71071_by.func_70441_a(add)) {
                player.func_71019_a(add, false);
            }
            prism.getItemHandler().setStackInSlot(0, null);
            prism.func_70296_d();
            world.func_180501_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.HAS_LENS, (Comparable)Boolean.valueOf(false)), 3);
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        boolean power = world.func_175687_A(pos) > 0 || world.func_175687_A(pos.func_177984_a()) > 0;
        boolean powered = (Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED);
        if (!world.field_72995_K) {
            if (power && !powered) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(true)), 3);
            } else if (!power && powered) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
        InventoryHelper.dropInventory(inv, world, state, pos);
        super.func_180663_b(world, pos, state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TilePrism();
    }

    @Override
    public void onBurstCollision(IManaBurst burst, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TilePrism) {
            ((TilePrism)tile).onBurstCollision(burst);
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.prism;
    }

    @Override
    public boolean isGhost(IBlockState state, World world, BlockPos pos) {
        return true;
    }
}

