/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.fx.ParticleRenderDispatcher;
import vazkii.botania.common.core.handler.ConfigHandler;

public class FXSparkle
extends Particle {
    private static final ResourceLocation vanillaParticles = new ResourceLocation("textures/particle/particles.png");
    public static final ResourceLocation particles = new ResourceLocation("botania:textures/misc/particles.png");
    private static final Queue<FXSparkle> queuedRenders = new ArrayDeque<FXSparkle>();
    private static final Queue<FXSparkle> queuedCorruptRenders = new ArrayDeque<FXSparkle>();
    private float f;
    private float f1;
    private float f2;
    private float f3;
    private float f4;
    private float f5;
    public boolean noClip = false;
    public boolean corrupt = false;
    public boolean fake = false;
    private int multiplier = 2;
    private final boolean shrink = true;
    public final int particle = 16;
    public boolean tinkle = false;
    public final boolean slowdown = true;
    public int currentColor = 0;

    public FXSparkle(World world, double x, double y, double z, float size, float red, float green, float blue, int m) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_70552_h = red;
        this.field_70553_i = green;
        this.field_70551_j = blue;
        this.field_82339_as = 0.5f;
        this.field_70545_g = 0.0f;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.field_70544_f *= size;
        this.field_70547_e = 3 * m;
        this.multiplier = m;
        this.noClip = false;
        this.func_187115_a(0.01f, 0.01f);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
    }

    public static void dispatchQueuedRenders(Tessellator tessellator) {
        ParticleRenderDispatcher.sparkleFxCount = 0;
        ParticleRenderDispatcher.fakeSparkleFxCount = 0;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ConfigHandler.matrixMode ? vanillaParticles : particles);
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (FXSparkle sparkle : queuedRenders) {
            sparkle.renderQueued(tessellator);
        }
        tessellator.func_78381_a();
        ShaderHelper.useShader(ShaderHelper.filmGrain);
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (FXSparkle sparkle : queuedCorruptRenders) {
            sparkle.renderQueued(tessellator);
        }
        tessellator.func_78381_a();
        ShaderHelper.releaseShader();
        queuedRenders.clear();
        queuedCorruptRenders.clear();
    }

    private void renderQueued(Tessellator tessellator) {
        if (this.fake) {
            ++ParticleRenderDispatcher.fakeSparkleFxCount;
        } else {
            ++ParticleRenderDispatcher.sparkleFxCount;
        }
        int part = 16 + this.field_70546_d / this.multiplier;
        float var8 = (float)(part % 8) / 8.0f;
        float var9 = var8 + 0.124875f;
        float var10 = (float)(part / 8) / 8.0f;
        float var11 = var10 + 0.124875f;
        float var12 = 0.1f * this.field_70544_f;
        float var13 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)this.f - field_70556_an);
        float var14 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)this.f - field_70554_ao);
        float var15 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)this.f - field_70555_ap);
        float var16 = 1.0f;
        tessellator.func_178180_c().func_181662_b((double)(var13 - this.f1 * (var12 *= (float)(this.field_70547_e - this.field_70546_d + 1) / (float)this.field_70547_e) - this.f4 * var12), (double)(var14 - this.f2 * var12), (double)(var15 - this.f3 * var12 - this.f5 * var12)).func_187315_a((double)var9, (double)var11).func_181666_a(this.field_70552_h * var16, this.field_70553_i * var16, this.field_70551_j * var16, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(var13 - this.f1 * var12 + this.f4 * var12), (double)(var14 + this.f2 * var12), (double)(var15 - this.f3 * var12 + this.f5 * var12)).func_187315_a((double)var9, (double)var10).func_181666_a(this.field_70552_h * var16, this.field_70553_i * var16, this.field_70551_j * var16, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(var13 + this.f1 * var12 + this.f4 * var12), (double)(var14 + this.f2 * var12), (double)(var15 + this.f3 * var12 + this.f5 * var12)).func_187315_a((double)var8, (double)var10).func_181666_a(this.field_70552_h * var16, this.field_70553_i * var16, this.field_70551_j * var16, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(var13 + this.f1 * var12 - this.f4 * var12), (double)(var14 - this.f2 * var12), (double)(var15 + this.f3 * var12 - this.f5 * var12)).func_187315_a((double)var8, (double)var11).func_181666_a(this.field_70552_h * var16, this.field_70553_i * var16, this.field_70551_j * var16, 1.0f).func_181675_d();
    }

    public void func_180434_a(VertexBuffer worldRendererIn, Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        this.f = f;
        this.f1 = f1;
        this.f2 = f2;
        this.f3 = f3;
        this.f4 = f4;
        this.f5 = f5;
        if (this.corrupt) {
            queuedCorruptRenders.add(this);
        } else {
            queuedRenders.add(this);
        }
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187130_j -= 0.04 * (double)this.field_70545_g;
        if (!this.noClip && !this.fake) {
            this.wiggleAround(this.field_187126_f, (this.func_187116_l().field_72338_b + this.func_187116_l().field_72337_e) / 2.0, this.field_187128_h);
        }
        this.field_187126_f += this.field_187129_i;
        this.field_187127_g += this.field_187130_j;
        this.field_187128_h += this.field_187131_k;
        this.field_187129_i *= 0.9080000019073486;
        this.field_187130_j *= 0.9080000019073486;
        this.field_187131_k *= 0.9080000019073486;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
        if (this.fake && this.field_70546_d > 1) {
            this.func_187112_i();
        }
    }

    public void setGravity(float value) {
        this.field_70545_g = value;
    }

    private boolean wiggleAround(double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        double d0 = x - (double)blockpos.func_177958_n();
        double d1 = y - (double)blockpos.func_177956_o();
        double d2 = z - (double)blockpos.func_177952_p();
        if (!this.field_187122_b.func_175623_d(blockpos)) {
            EnumFacing enumfacing = EnumFacing.UP;
            double d3 = Double.MAX_VALUE;
            if (!this.field_187122_b.func_175665_u(blockpos.func_177976_e()) && d0 < d3) {
                d3 = d0;
                enumfacing = EnumFacing.WEST;
            }
            if (!this.field_187122_b.func_175665_u(blockpos.func_177974_f()) && 1.0 - d0 < d3) {
                d3 = 1.0 - d0;
                enumfacing = EnumFacing.EAST;
            }
            if (!this.field_187122_b.func_175665_u(blockpos.func_177978_c()) && d2 < d3) {
                d3 = d2;
                enumfacing = EnumFacing.NORTH;
            }
            if (!this.field_187122_b.func_175665_u(blockpos.func_177968_d()) && 1.0 - d2 < d3) {
                d3 = 1.0 - d2;
                enumfacing = EnumFacing.SOUTH;
            }
            if (!this.field_187122_b.func_175665_u(blockpos.func_177984_a()) && 1.0 - d1 < d3) {
                d3 = 1.0 - d1;
                enumfacing = EnumFacing.UP;
            }
            float f = this.field_187136_p.nextFloat() * 0.05f + 0.01f;
            float f1 = enumfacing.func_176743_c().func_179524_a();
            float secondary = (this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.1f;
            if (enumfacing.func_176740_k() == EnumFacing.Axis.X) {
                this.field_187129_i += (double)(f1 * f);
                this.field_187130_j = this.field_187131_k = (double)secondary;
            } else if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
                this.field_187130_j += (double)(f1 * f);
                this.field_187129_i = this.field_187131_k = (double)secondary;
            } else if (enumfacing.func_176740_k() == EnumFacing.Axis.Z) {
                this.field_187131_k += (double)(f1 * f);
                this.field_187129_i = this.field_187130_j = (double)secondary;
            }
            return true;
        }
        return false;
    }
}

