/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.energyconverters.common.tiles;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;
import net.xalcon.energyconverters.EnergyConverters;
import net.xalcon.energyconverters.common.tiles.TileEntityConverterBase;
import net.xalcon.energyconverters.common.tiles.TileEntityEnergyBridge;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.power.IEnergyInterfaceTile;

@Optional.Interface(iface="reborncore.api.power.IEnergyInterfaceTile", modid="reborncore", striprefs=true)
public class TileEntityTechRebornConsumer
extends TileEntityConverterBase
implements IEnergyInterfaceTile {
    private EnumPowerTier tier;

    public TileEntityTechRebornConsumer(EnumPowerTier tier) {
        this.tier = tier;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tier = EnumPowerTier.values()[compound.func_74762_e("tier")];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("tier", this.tier.ordinal());
        return super.func_189515_b(compound);
    }

    public double getEnergy() {
        TileEntityEnergyBridge bridge = this.getEnergyBridge();
        return bridge == null ? 0.0 : bridge.getStoredEnergy() / EnergyConverters.getConfig().getRfConversion();
    }

    public void setEnergy(double v) {
    }

    public double getMaxPower() {
        TileEntityEnergyBridge bridge = this.getEnergyBridge();
        return bridge == null ? 0.0 : bridge.getStoredEnergyMax() / EnergyConverters.getConfig().getRfConversion();
    }

    public boolean canAddEnergy(double v) {
        return true;
    }

    public double addEnergy(double v) {
        return this.addEnergy(v, false);
    }

    public double addEnergy(double v, boolean simulate) {
        double ratio = EnergyConverters.getConfig().getRfConversion();
        TileEntityEnergyBridge bridge = this.getEnergyBridge();
        return bridge == null ? 0.0 : bridge.addEnergy(v * ratio, simulate) / ratio;
    }

    public boolean canUseEnergy(double v) {
        return false;
    }

    public double useEnergy(double v) {
        return 0.0;
    }

    public double useEnergy(double v, boolean b) {
        return 0.0;
    }

    public boolean canAcceptEnergy(EnumFacing enumFacing) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing enumFacing) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return this.tier.getMaxInput();
    }

    public EnumPowerTier getTier() {
        return this.tier;
    }
}

