/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.energyconverters.common.tiles;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.xalcon.energyconverters.EnergyConverters;
import net.xalcon.energyconverters.common.tiles.TileEntityEnergyConvertersProducer;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2", striprefs=true)
public class TileEntityProducerEu
extends TileEntityEnergyConvertersProducer
implements ITickable,
IEnergySource {
    private double maxEnergyUnits;
    private boolean addedToNet;
    private int tier;

    public TileEntityProducerEu() {
        this.addedToNet = false;
    }

    public TileEntityProducerEu(int tier) {
        this.tier = tier;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tier = compound.func_74762_e("tier");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("tier", this.tier);
        return super.func_189515_b(compound);
    }

    private void onLoaded() {
        super.onLoad();
        if (this.addedToNet || FMLCommonHandler.instance().getEffectiveSide().isClient() || !Info.isIc2Available()) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
        this.addedToNet = true;
        this.maxEnergyUnits = EnergyNet.instance.getPowerFromTier(this.getSourceTier());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.addedToNet && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToNet = false;
        }
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.addedToNet) {
            this.onLoaded();
        }
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        return Math.min(this.getBridgeEnergyStored() / EnergyConverters.getConfig().getIc2Conversion(), this.maxEnergyUnits);
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double v) {
        this.retrieveEnergyFromBridge(v * EnergyConverters.getConfig().getIc2Conversion(), false);
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        return this.tier;
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(IEnergyAcceptor iEnergyAcceptor, EnumFacing enumFacing) {
        return true;
    }
}

