/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.gui;

import com.google.common.collect.Lists;
import com.mrdimka.hammercore.client.utils.RenderUtil;
import com.mrdimka.hammercore.common.InterItemStack;
import com.mrdimka.solarfluxreborn.gui.ContainerSolarPanel;
import com.mrdimka.solarfluxreborn.te.SolarPanelTileEntity;
import com.mrdimka.solarfluxreborn.utility.Lang;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiSolarPanel
extends GuiContainer {
    private static final ResourceLocation ELEMENTS = new ResourceLocation("solarfluxreborn".toLowerCase(), "textures/gui/elements.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("solarfluxreborn".toLowerCase(), "textures/gui/solar.png");
    private static final int GAUGE_WIDTH = 18;
    private static final int GAUGE_HEIGHT = 50;
    private static final int GAUGE_INNER_WIDTH = 16;
    private static final int GAUGE_INNER_HEIGHT = 48;
    private static final int GAUGE_INNER_OFFSET_X = 1;
    private static final int GAUGE_INNER_OFFSET_Y = 1;
    private static final int GAUGE_SRC_X = 64;
    private static final int GAUGE_SRC_Y = 62;
    private static final int GAUGE_INNER_SRC_X = 0;
    private static final int GAUGE_INNER_SRC_Y = 64;
    private static final int BORDER_OFFSET = 8;
    private final SolarPanelTileEntity solar;
    private final InventoryPlayer pinv;
    private List<String> tooltip = Lists.newArrayList();

    public GuiSolarPanel(InventoryPlayer pinv, SolarPanelTileEntity solar) {
        super((Container)new ContainerSolarPanel(pinv, solar));
        this.solar = solar;
        this.pinv = pinv;
        this.field_146999_f = 176;
        this.field_147000_g = 180;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.pinv.func_145818_k_() ? this.pinv.func_70005_c_() : I18n.func_135052_a((String)this.pinv.func_70005_c_(), (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%s: %,d %s", Lang.localise("energy.stored"), this.solar.getEnergyStored(), Lang.localise("rf")), 8, 8, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%s: %,d %s", Lang.localise("energy.capacity"), this.solar.getMaxEnergyStored(), Lang.localise("rf")), 8, 18, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%s: %,d %s", Lang.localise("energy.generation"), this.solar.getCurrentEnergyGeneration(), Lang.localise("rfPerTick")), 8, 28, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%s: %,d%%", Lang.localise("energy.efficiency"), Math.round(100.0 * (double)this.solar.getCurrentEnergyGeneration() / (double)this.solar.getMaximumEnergyGeneration())), 8, 38, 0x404040);
        for (int i = 0; i < 5; ++i) {
            ItemStack stack = this.solar.func_70301_a(i);
            boolean nul = InterItemStack.isStackNull((ItemStack)stack);
            if (!nul) {
                this.field_146297_k.func_175599_af().func_175042_a(stack, 17 + i * 18, 59);
            }
            GlStateManager.func_179097_i();
            if (!nul) {
                String s = InterItemStack.getStackSize((ItemStack)stack) + "";
                this.field_146289_q.func_175065_a(s, (float)(34 + i * 18 - this.field_146289_q.func_78256_a(s)), 68.0f, 0xFFFFFF, true);
            }
            if (this.inBounds(this.field_147003_i + 17 + i * 18, this.field_147009_r + 59, 16, 16, mouseX, mouseY)) {
                int color = -1996488705;
                this.func_73733_a(17 + i * 18, 59, 17 + i * 18 + 16, 75, color, color);
                if (!InterItemStack.isStackNull((ItemStack)stack)) {
                    this.tooltip.clear();
                    this.tooltip.addAll(stack.func_82840_a(this.pinv.field_70458_d, this.field_146297_k.field_71474_y.field_82882_x));
                }
            }
            GlStateManager.func_179126_j();
        }
    }

    protected void func_146976_a(float pOpacity, int pMouseX, int pMouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        RenderUtil.drawTexturedModalRect((double)xStart, (double)yStart, (double)0.0, (double)0.0, (double)this.field_146999_f, (double)this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(ELEMENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        for (int i = 0; i < 5; ++i) {
            RenderUtil.drawTexturedModalRect((double)(xStart + 17 + i * 18 - 1), (double)(yStart + 59 - 1), (double)0.0, (double)0.0, (double)18.0, (double)18.0);
        }
        this.drawPower(xStart + this.field_146999_f - 18 - 8, yStart + 8 + 32, pMouseX, pMouseY);
        this.drawSun(xStart + this.field_146999_f - 36 - 8 - 4, yStart + 8 + 32, pMouseX, pMouseY);
    }

    private void drawPower(int pLeft, int pTop, int pMouseX, int pMouseY) {
        RenderUtil.drawTexturedModalRect((double)(pLeft + 1), (double)(pTop + 1), (double)16.0, (double)64.0, (double)16.0, (double)48.0);
        double height = this.solar.getScaledEnergyStoredFraction(48);
        double offset = 48.0 - height;
        RenderUtil.drawTexturedModalRect((double)(pLeft + 1), (double)((double)(pTop + 1) + offset), (double)0.0, (double)(64.0 + offset), (double)16.0, (double)height);
        RenderUtil.drawTexturedModalRect((double)pLeft, (double)((double)(pTop + 1) + offset - 1.0), (double)64.0, (double)61.0, (double)18.0, (double)1.0);
        int srcX = 64;
        boolean hover = this.inBounds(pLeft, pTop, 18, 50, pMouseX, pMouseY);
        if (hover) {
            srcX += 18;
        }
        RenderUtil.drawTexturedModalRect((double)pLeft, (double)pTop, (double)srcX, (double)62.0, (double)18.0, (double)50.0);
        if (hover) {
            String str = String.format("%s: %,d/%,d", Lang.localise("energy.stored"), this.solar.getEnergyStored(), this.solar.getMaxEnergyStored());
            this.drawMouseOver(str);
        }
    }

    public void func_73863_a(int pMouseX, int pMouseY, float pOpacity) {
        this.clearMouseHoverCache();
        super.func_73863_a(pMouseX, pMouseY, pOpacity);
        this.drawHoveringText(this.tooltip, pMouseX, pMouseY, this.field_146289_q);
    }

    public void drawMouseOver(String pText) {
        if (pText != null) {
            this.clearMouseHoverCache();
            Collections.addAll(this.tooltip, pText.split("\n"));
        }
    }

    private void clearMouseHoverCache() {
        this.tooltip.clear();
    }

    public boolean inBounds(int pLeft, int pTop, int pWidth, int pHeight, int pMouseX, int pMouseY) {
        return pLeft <= pMouseX && pMouseX < pLeft + pWidth && pTop <= pMouseY && pMouseY < pTop + pHeight;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    private void drawSun(int pLeft, int pTop, int pMouseX, int pMouseY) {
        RenderUtil.drawTexturedModalRect((double)(pLeft + 1), (double)(pTop + 1), (double)48.0, (double)64.0, (double)16.0, (double)48.0);
        this.solar.updateCurrentEnergyGeneration(this.solar.func_174877_v().func_177984_a());
        double height = 48.0 * (double)this.solar.getSunIntensity();
        double offset = 48.0 - height;
        RenderUtil.drawTexturedModalRect((double)(pLeft + 1), (double)((double)(pTop + 1) + offset), (double)32.0, (double)(64.0 + offset), (double)16.0, (double)height);
        RenderUtil.drawTexturedModalRect((double)pLeft, (double)((double)(pTop + 1) + offset - 1.0), (double)82.0, (double)61.0, (double)18.0, (double)1.0);
        int srcX = 64;
        boolean hover = this.inBounds(pLeft, pTop, 18, 50, pMouseX, pMouseY);
        if (hover) {
            srcX += 18;
        }
        RenderUtil.drawTexturedModalRect((double)pLeft, (double)pTop, (double)srcX, (double)62.0, (double)18.0, (double)50.0);
        if (hover) {
            String str = String.format("%s: %d%%", Lang.localise("sun.intensity"), (int)(100.0f * this.solar.getSunIntensity()));
            this.drawMouseOver(str);
        }
    }
}

