/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.client.gui.GuiHandler;
import org.cyclops.cyclopscore.client.icon.IconProvider;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.client.key.KeyRegistry;
import org.cyclops.cyclopscore.command.CommandMod;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.LoggerHelper;
import org.cyclops.cyclopscore.init.Debug;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.init.RegistryManager;
import org.cyclops.cyclopscore.modcompat.IMCHandler;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.network.PacketHandler;
import org.cyclops.cyclopscore.persist.world.WorldStorage;
import org.cyclops.cyclopscore.proxy.ClientProxyComponent;
import org.cyclops.cyclopscore.proxy.ICommonProxy;

public abstract class ModBase {
    public static final EnumReferenceKey<String> REFKEY_MOD_VERSION = EnumReferenceKey.create("mod_version", String.class);
    public static final EnumReferenceKey<String> REFKEY_TEXTURE_PATH_GUI = EnumReferenceKey.create("texture_path_gui", String.class);
    public static final EnumReferenceKey<String> REFKEY_TEXTURE_PATH_MODELS = EnumReferenceKey.create("texture_path_models", String.class);
    public static final EnumReferenceKey<String> REFKEY_TEXTURE_PATH_SKINS = EnumReferenceKey.create("texture_path_skins", String.class);
    public static final EnumReferenceKey<Boolean> REFKEY_RETROGEN = EnumReferenceKey.create("retrogen", Boolean.class);
    public static final EnumReferenceKey<Boolean> REFKEY_DEBUGCONFIG = EnumReferenceKey.create("debug_config", Boolean.class);
    public static final EnumReferenceKey<Boolean> REFKEY_CRASH_ON_INVALID_RECIPE = EnumReferenceKey.create("crash_on_invalid_recipe", Boolean.class);
    public static final EnumReferenceKey<Boolean> REFKEY_CRASH_ON_MODCOMPAT_CRASH = EnumReferenceKey.create("crash_on_modcompat_crash", Boolean.class);
    public static final EnumReferenceKey<Boolean> REFKEY_INFOBOOK_REWARDS = EnumReferenceKey.create("rewards", Boolean.class);
    private final String modId;
    private final String modName;
    private final LoggerHelper loggerHelper;
    private final Set<IInitListener> initListeners;
    private final ConfigHandler configHandler;
    private final Map<EnumReferenceKey, Object> genericReference = Maps.newHashMap();
    private final List<WorldStorage> worldStorages = Lists.newLinkedList();
    private final GuiHandler guiHandler;
    private final RegistryManager registryManager;
    private final RecipeHandler recipeHandler;
    private final IKeyRegistry keyRegistry;
    private final PacketHandler packetHandler;
    private final ModCompatLoader modCompatLoader;
    private final CapabilityConstructorRegistry capabilityConstructorRegistry;
    private final IMCHandler imcHandler;
    private final Debug debug;
    private CreativeTabs defaultCreativeTab = null;
    private File configFolder = null;

    public ModBase(String modId, String modName) {
        this.modId = modId;
        this.modName = modName;
        this.loggerHelper = this.constructLoggerHelper();
        this.initListeners = Sets.newHashSet();
        this.configHandler = this.constructConfigHandler();
        this.guiHandler = this.constructGuiHandler();
        this.registryManager = this.constructRegistryManager();
        this.recipeHandler = this.constructRecipeHandler();
        this.keyRegistry = new KeyRegistry();
        this.packetHandler = this.constructPacketHandler();
        this.modCompatLoader = this.constructModCompatLoader();
        this.capabilityConstructorRegistry = this.constructCapabilityConstructorRegistry();
        this.imcHandler = this.constructIMCHandler();
        this.debug = new Debug(this);
        this.populateDefaultGenericReferences();
        this.addInitListeners(this.getModCompatLoader());
        this.loadModCompats(this.getModCompatLoader());
    }

    protected LoggerHelper constructLoggerHelper() {
        return new LoggerHelper(this.modName);
    }

    protected ConfigHandler constructConfigHandler() {
        return new ConfigHandler(this);
    }

    protected GuiHandler constructGuiHandler() {
        return new GuiHandler(this);
    }

    protected RegistryManager constructRegistryManager() {
        return new RegistryManager();
    }

    protected abstract RecipeHandler constructRecipeHandler();

    protected PacketHandler constructPacketHandler() {
        return new PacketHandler(this);
    }

    protected ModCompatLoader constructModCompatLoader() {
        return new ModCompatLoader(this);
    }

    protected CapabilityConstructorRegistry constructCapabilityConstructorRegistry() {
        return new CapabilityConstructorRegistry(this);
    }

    protected IMCHandler constructIMCHandler() {
        return new IMCHandler(this);
    }

    protected ICommand constructBaseCommand() {
        return new CommandMod(this, Maps.newHashMap());
    }

    @SideOnly(value=Side.CLIENT)
    public IconProvider getIconProvider() {
        return ((ClientProxyComponent)this.getProxy()).getIconProvider();
    }

    public <T> void putGenericReference(EnumReferenceKey<T> key, T value) {
        this.genericReference.put(key, value);
    }

    private void populateDefaultGenericReferences() {
        this.putGenericReference(REFKEY_TEXTURE_PATH_GUI, "textures/gui/");
        this.putGenericReference(REFKEY_TEXTURE_PATH_MODELS, "textures/models/");
        this.putGenericReference(REFKEY_TEXTURE_PATH_SKINS, "textures/skins/");
        this.putGenericReference(REFKEY_RETROGEN, false);
        this.putGenericReference(REFKEY_DEBUGCONFIG, false);
        this.putGenericReference(REFKEY_CRASH_ON_INVALID_RECIPE, false);
        this.putGenericReference(REFKEY_CRASH_ON_MODCOMPAT_CRASH, false);
        this.putGenericReference(REFKEY_INFOBOOK_REWARDS, true);
    }

    protected void loadModCompats(ModCompatLoader modCompatLoader) {
    }

    public <T> T getReferenceValue(EnumReferenceKey<T> key) {
        if (!this.genericReference.containsKey(key)) {
            throw new IllegalArgumentException("Could not find " + key + " as generic reference item.");
        }
        return (T)this.genericReference.get(key);
    }

    public void log(String message) {
        this.log(Level.INFO, message);
    }

    public void log(Level level, String message) {
        this.loggerHelper.log(level, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitListeners(IInitListener initListener) {
        Set<IInitListener> set = this.initListeners;
        synchronized (set) {
            this.initListeners.add(initListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IInitListener> getSafeInitListeners() {
        HashSet clonedInitListeners;
        Set<IInitListener> set = this.initListeners;
        synchronized (set) {
            clonedInitListeners = Sets.newHashSet(this.initListeners);
        }
        return clonedInitListeners;
    }

    protected void callInitStepListeners(IInitListener.Step step) {
        for (IInitListener initListener : this.getSafeInitListeners()) {
            initListener.onInit(step);
        }
    }

    public void preInit(FMLPreInitializationEvent event) {
        ICommonProxy proxy;
        this.log(Level.TRACE, "preInit()");
        if (this.getConfigFolder() == null) {
            String rootFolderName = event.getModConfigurationDirectory() + "/" + this.getModId();
            File configFolder = new File(rootFolderName);
            this.setConfigFolder(configFolder);
        }
        this.onGeneralConfigsRegister(this.getConfigHandler());
        this.getConfigHandler().handle(event);
        this.onMainConfigsRegister(this.getConfigHandler());
        this.callInitStepListeners(IInitListener.Step.PREINIT);
        if (this.getReferenceValue(REFKEY_DEBUGCONFIG).booleanValue()) {
            this.getDebug().checkPreConfigurables(this.getConfigHandler());
        }
        this.getConfigHandler().handle(event);
        if (this.getReferenceValue(REFKEY_DEBUGCONFIG).booleanValue()) {
            this.getDebug().checkPostConfigurables();
        }
        if ((proxy = this.getProxy()) != null) {
            proxy.registerEventHooks();
        }
    }

    public void init(FMLInitializationEvent event) {
        RecipeHandler recipeHandler;
        this.log(Level.TRACE, "init()");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this.getModId(), (IGuiHandler)this.getGuiHandler());
        this.getDefaultCreativeTab();
        this.getConfigHandler().polishConfigs();
        this.callInitStepListeners(IInitListener.Step.INIT);
        ICommonProxy proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerRenderers();
            proxy.registerKeyBindings(this.getKeyRegistry());
            this.getPacketHandler().init();
            proxy.registerPacketHandlers(this.getPacketHandler());
            proxy.registerTickHandlers();
        }
        if ((recipeHandler = this.getRecipeHandler()) != null) {
            recipeHandler.registerRecipes(this.getConfigFolder());
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.log(Level.TRACE, "postInit()");
        this.callInitStepListeners(IInitListener.Step.POSTINIT);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand(this.constructBaseCommand());
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        for (WorldStorage worldStorage : this.worldStorages) {
            worldStorage.onAboutToStartEvent(event);
        }
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        for (WorldStorage worldStorage : this.worldStorages) {
            worldStorage.onStartedEvent(event);
        }
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        for (WorldStorage worldStorage : this.worldStorages) {
            worldStorage.onStoppingEvent(event);
        }
    }

    public void registerWorldStorage(WorldStorage worldStorage) {
        this.worldStorages.add(worldStorage);
    }

    public abstract CreativeTabs constructDefaultCreativeTab();

    public final void registerConfig(ExtendedConfig<?> extendedConfig) {
        this.getConfigHandler().add(extendedConfig);
    }

    public void onGeneralConfigsRegister(ConfigHandler configHandler) {
    }

    public void onMainConfigsRegister(ConfigHandler configHandler) {
    }

    public final CreativeTabs getDefaultCreativeTab() {
        if (this.defaultCreativeTab == null) {
            this.defaultCreativeTab = this.constructDefaultCreativeTab();
        }
        return this.defaultCreativeTab;
    }

    public abstract ICommonProxy getProxy();

    public String toString() {
        return this.getModId();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public static ModBase get(String modId) {
        ModContainer modContainer = (ModContainer)Loader.instance().getIndexedModList().get(modId);
        Object mod = modContainer.getMod();
        if (mod instanceof ModBase) {
            return (ModBase)mod;
        }
        return null;
    }

    public String getModId() {
        return this.modId;
    }

    public String getModName() {
        return this.modName;
    }

    public LoggerHelper getLoggerHelper() {
        return this.loggerHelper;
    }

    public Set<IInitListener> getInitListeners() {
        return this.initListeners;
    }

    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    public Map<EnumReferenceKey, Object> getGenericReference() {
        return this.genericReference;
    }

    public List<WorldStorage> getWorldStorages() {
        return this.worldStorages;
    }

    public GuiHandler getGuiHandler() {
        return this.guiHandler;
    }

    public RegistryManager getRegistryManager() {
        return this.registryManager;
    }

    public RecipeHandler getRecipeHandler() {
        return this.recipeHandler;
    }

    public IKeyRegistry getKeyRegistry() {
        return this.keyRegistry;
    }

    public PacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public ModCompatLoader getModCompatLoader() {
        return this.modCompatLoader;
    }

    public CapabilityConstructorRegistry getCapabilityConstructorRegistry() {
        return this.capabilityConstructorRegistry;
    }

    public IMCHandler getImcHandler() {
        return this.imcHandler;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public File getConfigFolder() {
        return this.configFolder;
    }

    public void setDefaultCreativeTab(CreativeTabs defaultCreativeTab) {
        this.defaultCreativeTab = defaultCreativeTab;
    }

    public void setConfigFolder(File configFolder) {
        this.configFolder = configFolder;
    }

    public static class EnumReferenceKey<T> {
        private final String key;
        private final Class<T> type;

        private EnumReferenceKey(String key, Class<T> type) {
            this.key = key;
            this.type = type;
        }

        public static <T> EnumReferenceKey<T> create(String key, Class<T> type) {
            return new EnumReferenceKey<T>(key, type);
        }

        public String getKey() {
            return this.key;
        }

        public Class<T> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumReferenceKey)) {
                return false;
            }
            EnumReferenceKey other = (EnumReferenceKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Class<T> this$type = this.getType();
            Class<T> other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnumReferenceKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 0 : $key.hashCode());
            Class<T> $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "ModBase.EnumReferenceKey(key=" + this.getKey() + ", type=" + this.getType() + ")";
        }
    }
}

