/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigProperty;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.IChangedCallback;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.ModBase;

public class ConfigHandler
extends LinkedHashSet<ExtendedConfig> {
    private final ModBase mod;
    private Configuration config;
    private final LinkedHashSet<ExtendedConfig> processedConfigs = new LinkedHashSet();
    private final Map<String, ExtendedConfig> configDictionary = Maps.newHashMap();
    private final Set<String> categories = Sets.newHashSet();
    private final Map<String, ConfigProperty> commandableProperties = Maps.newHashMap();

    @Override
    public boolean add(ExtendedConfig e) {
        this.addToConfigDictionary(e);
        return super.add(e);
    }

    public void addToConfigDictionary(ExtendedConfig e) {
        this.configDictionary.put(e.getNamedId(), e);
    }

    public void handle(FMLPreInitializationEvent event) {
        if (this.getConfig() == null) {
            Configuration config = new Configuration(event.getSuggestedConfigurationFile());
            this.setConfig(config);
            config.load();
        }
        this.loadConfig();
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public void loadConfig() {
        for (ExtendedConfig eConfig : this) {
            this.addCategory(eConfig.getHolderType().getCategory());
            if (eConfig.isHardDisabled()) continue;
            for (ConfigProperty configProperty : eConfig.configProperties) {
                this.categories.add(configProperty.getCategory());
                configProperty.save(this.config);
                if (!configProperty.isCommandable()) continue;
                this.commandableProperties.put(configProperty.getName(), configProperty);
            }
            ConfigurableType type = eConfig.getHolderType();
            type.getElementTypeAction().commonRun(eConfig, this.config);
            if (!eConfig.isEnabled()) continue;
            eConfig.onRegistered();
            this.mod.log(Level.TRACE, "Registered " + eConfig.getNamedId());
            this.processedConfigs.add(eConfig);
            this.mod.addInitListeners(new ConfigInitListener(eConfig));
        }
        this.removeAll(this);
        this.config.save();
    }

    public void polishConfigs() {
        for (ExtendedConfig eConfig : this.processedConfigs) {
            ConfigurableType type = eConfig.getHolderType();
            type.getElementTypeAction().polish(eConfig);
        }
    }

    public void syncProcessedConfigs() {
        for (ExtendedConfig eConfig : this.processedConfigs) {
            for (ConfigProperty configProperty : eConfig.configProperties) {
                configProperty.save(this.config, false);
            }
            ConfigurableType type = eConfig.getHolderType();
            type.getElementTypeAction().preRun(eConfig, this.config, false);
        }
        this.getConfig().save();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public Map<String, ExtendedConfig> getDictionary() {
        return this.configDictionary;
    }

    public static boolean isEnabled(Class<? extends ExtendedConfig> config) {
        try {
            return ((ExtendedConfig)config.getField("_instance").get(null)).isEnabled();
        }
        catch (NullPointerException e1) {
            return false;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
        catch (IllegalAccessException e3) {
            return false;
        }
        catch (NoSuchFieldException e3) {
            return false;
        }
        catch (SecurityException e4) {
            return false;
        }
    }

    @Nullable
    public static ExtendedConfig<?> getConfigFromItem(Item item) {
        if (item instanceof IConfigurable) {
            return ((IConfigurable)item).getConfig();
        }
        Block block = Block.func_149634_a((Item)item);
        if (block != Blocks.field_150350_a && block instanceof IConfigurable) {
            return ((IConfigurable)block).getConfig();
        }
        return null;
    }

    @Nullable
    public static ExtendedConfig<?> getConfigFromFluid(Fluid fluid) {
        if (fluid instanceof IConfigurable) {
            return ((IConfigurable)fluid).getConfig();
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigHandler)) {
            return false;
        }
        ConfigHandler other = (ConfigHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LinkedHashSet<ExtendedConfig> this$processedConfigs = this.getProcessedConfigs();
        LinkedHashSet<ExtendedConfig> other$processedConfigs = other.getProcessedConfigs();
        if (this$processedConfigs == null ? other$processedConfigs != null : !((Object)this$processedConfigs).equals(other$processedConfigs)) {
            return false;
        }
        Map<String, ExtendedConfig> this$configDictionary = this.getConfigDictionary();
        Map<String, ExtendedConfig> other$configDictionary = other.getConfigDictionary();
        if (this$configDictionary == null ? other$configDictionary != null : !((Object)this$configDictionary).equals(other$configDictionary)) {
            return false;
        }
        Set<String> this$categories = this.getCategories();
        Set<String> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        Map<String, ConfigProperty> this$commandableProperties = this.getCommandableProperties();
        Map<String, ConfigProperty> other$commandableProperties = other.getCommandableProperties();
        return !(this$commandableProperties == null ? other$commandableProperties != null : !((Object)this$commandableProperties).equals(other$commandableProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigHandler;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        LinkedHashSet<ExtendedConfig> $processedConfigs = this.getProcessedConfigs();
        result = result * 59 + ($processedConfigs == null ? 0 : ((Object)$processedConfigs).hashCode());
        Map<String, ExtendedConfig> $configDictionary = this.getConfigDictionary();
        result = result * 59 + ($configDictionary == null ? 0 : ((Object)$configDictionary).hashCode());
        Set<String> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 0 : ((Object)$categories).hashCode());
        Map<String, ConfigProperty> $commandableProperties = this.getCommandableProperties();
        result = result * 59 + ($commandableProperties == null ? 0 : ((Object)$commandableProperties).hashCode());
        return result;
    }

    @ConstructorProperties(value={"mod"})
    public ConfigHandler(ModBase mod) {
        this.mod = mod;
    }

    public ModBase getMod() {
        return this.mod;
    }

    public LinkedHashSet<ExtendedConfig> getProcessedConfigs() {
        return this.processedConfigs;
    }

    public Map<String, ExtendedConfig> getConfigDictionary() {
        return this.configDictionary;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public Map<String, ConfigProperty> getCommandableProperties() {
        return this.commandableProperties;
    }

    @Override
    public String toString() {
        return "ConfigHandler(mod=" + this.getMod() + ", config=" + this.getConfig() + ", processedConfigs=" + this.getProcessedConfigs() + ", configDictionary=" + this.getConfigDictionary() + ", categories=" + this.getCategories() + ", commandableProperties=" + this.getCommandableProperties() + ")";
    }

    public static class ConfigInitListener
    implements IInitListener {
        private ExtendedConfig<?> config;

        public ConfigInitListener(ExtendedConfig<?> config) {
            this.config = config;
        }

        @Override
        public void onInit(IInitListener.Step step) {
            this.config.onInit(step);
            if (step == IInitListener.Step.POSTINIT) {
                for (ConfigProperty property : this.config.configProperties) {
                    IChangedCallback changedCallback = property.getCallback().getChangedCallback();
                    if (changedCallback == null) continue;
                    changedCallback.onRegisteredPostInit(property.getValue());
                }
            }
        }
    }
}

