/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.command;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.cyclops.cyclopscore.command.CommandConfigSet;
import org.cyclops.cyclopscore.command.CommandMod;
import org.cyclops.cyclopscore.config.ConfigProperty;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;

public class CommandConfig
extends CommandMod {
    public static final String NAME = "config";

    public CommandConfig(ModBase mod) {
        super(mod, NAME);
    }

    public CommandConfig(ModBase mod, String name) {
        super(mod, NAME);
    }

    @Override
    public String getFullCommand() {
        return super.getFullCommand() + " " + NAME;
    }

    @Override
    protected List<String> getAliases() {
        LinkedList<String> list = new LinkedList<String>();
        list.add(NAME);
        return list;
    }

    @Override
    protected Map<String, ICommand> getSubcommands() {
        HashMap<String, ICommand> map = new HashMap<String, ICommand>();
        for (Map.Entry<String, ConfigProperty> entry : this.getMod().getConfigHandler().getCommandableProperties().entrySet()) {
            String name = entry.getValue().getName();
            map.put(name, new CommandConfigSet(this.getMod(), name, entry.getValue()));
        }
        return map;
    }

    @Override
    public void processCommandHelp(ICommandSender icommandsender, String[] astring) throws CommandException {
        Iterator<String> it = this.getSubcommands().keySet().iterator();
        if (!it.hasNext()) {
            throw new CommandException(L10NHelpers.localize("chat.cyclopscore.command.noConfigsFound"), new Object[0]);
        }
        icommandsender.func_145747_a((ITextComponent)new TextComponentString(this.joinStrings(it, ", ")));
    }
}

