/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.model;

import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.lwjgl.util.Color;

public abstract class DynamicBaseModel
implements IPerspectiveAwareModel {
    protected static final float[][] ROTATION_UV = new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}};
    protected static final int[] ROTATION_FIX = new int[]{2, 0, 2, 0, 1, 3};
    protected static final float[][] UVS = new float[][]{{0.0f, 0.0f}, {1.0f, 1.0f}};

    protected static Vec3d rotate(Vec3d vec, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d(vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
            }
            case UP: {
                return new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case NORTH: {
                return new Vec3d(vec.field_72450_a, vec.field_72449_c, -vec.field_72448_b);
            }
            case SOUTH: {
                return new Vec3d(vec.field_72450_a, -vec.field_72449_c, vec.field_72448_b);
            }
            case WEST: {
                return new Vec3d(-vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
            }
            case EAST: {
                return new Vec3d(vec.field_72448_b, -vec.field_72450_a, vec.field_72449_c);
            }
        }
        return vec;
    }

    protected static Vec3d revRotate(Vec3d vec, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d(vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
            }
            case UP: {
                return new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case NORTH: {
                return new Vec3d(vec.field_72450_a, -vec.field_72449_c, vec.field_72448_b);
            }
            case SOUTH: {
                return new Vec3d(vec.field_72450_a, vec.field_72449_c, -vec.field_72448_b);
            }
            case WEST: {
                return new Vec3d(vec.field_72448_b, -vec.field_72450_a, vec.field_72449_c);
            }
            case EAST: {
                return new Vec3d(-vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
            }
        }
        return vec;
    }

    protected static int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v) {
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.func_94214_a((double)u)), Float.floatToRawIntBits(texture.func_94207_b((double)v)), 0};
    }

    protected static void addBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, EnumFacing side) {
        DynamicBaseModel.addBakedQuad(quads, x1, x2, z1, z2, y, texture, -1, side);
    }

    protected static void addBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, int shadeColor, EnumFacing side) {
        DynamicBaseModel.addBakedQuad(quads, x1, x2, z1, z2, y, texture, shadeColor, side, false);
    }

    protected static void addColoredBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, Color shadeColor, EnumFacing side) {
        int color = Helpers.RGBAToInt(shadeColor.getBlue(), shadeColor.getGreen(), shadeColor.getRed(), shadeColor.getAlpha());
        DynamicBaseModel.addColoredBakedQuad(quads, x1, x2, z1, z2, y, texture, color, side);
    }

    protected static void addColoredBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, int shadeColor, EnumFacing side) {
        DynamicBaseModel.addBakedQuad(quads, x1, x2, z1, z2, y, texture, shadeColor, side, true);
    }

    private static void addBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, int shadeColor, EnumFacing side, boolean isColored) {
        DynamicBaseModel.addBakedQuadRotated(quads, x1, x2, z1, z2, y, texture, side, 0, isColored, shadeColor, new float[][]{{x1, z1}, {x1, z2}, {x2, z2}, {x2, z1}});
    }

    protected static void addBakedQuadRotated(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, EnumFacing side, int rotation) {
        DynamicBaseModel.addBakedQuadRotated(quads, x1, x2, z1, z2, y, texture, side, rotation, false, -1, ROTATION_UV);
    }

    protected static void addBakedQuadRotated(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, EnumFacing side, int rotation, boolean isColored, int shadeColor, float[][] uvs) {
        Vec3d v1 = DynamicBaseModel.rotate(new Vec3d((double)x1 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d v2 = DynamicBaseModel.rotate(new Vec3d((double)x1 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d v3 = DynamicBaseModel.rotate(new Vec3d((double)x2 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d v4 = DynamicBaseModel.rotate(new Vec3d((double)x2 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        int[] data = Ints.concat((int[][])new int[][]{DynamicBaseModel.vertexToInts((float)v1.field_72450_a, (float)v1.field_72448_b, (float)v1.field_72449_c, shadeColor, texture, uvs[(0 + rotation) % 4][0] * 16.0f, uvs[(0 + rotation) % 4][1] * 16.0f), DynamicBaseModel.vertexToInts((float)v2.field_72450_a, (float)v2.field_72448_b, (float)v2.field_72449_c, shadeColor, texture, uvs[(1 + rotation) % 4][0] * 16.0f, uvs[(1 + rotation) % 4][1] * 16.0f), DynamicBaseModel.vertexToInts((float)v3.field_72450_a, (float)v3.field_72448_b, (float)v3.field_72449_c, shadeColor, texture, uvs[(2 + rotation) % 4][0] * 16.0f, uvs[(2 + rotation) % 4][1] * 16.0f), DynamicBaseModel.vertexToInts((float)v4.field_72450_a, (float)v4.field_72448_b, (float)v4.field_72449_c, shadeColor, texture, uvs[(3 + rotation) % 4][0] * 16.0f, uvs[(3 + rotation) % 4][1] * 16.0f)});
        ForgeHooksClient.fillNormal((int[])data, (EnumFacing)side);
        quads.add(new BakedQuad(data, -1, side, texture, false, Attributes.DEFAULT_BAKED_FORMAT));
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return Collections.emptyList();
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, ModelHelpers.DEFAULT_PERSPECTIVE_TRANSFORMS, (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

